/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.expressions.ListExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class DB2Platform
extends DatabasePlatform {
    public DB2Platform() {
        this.cursorCode = -100008;
        this.shouldBindPartialParameters = true;
        this.pingSQL = "VALUES(1)";
        this.supportsReturnGeneratedKeys = true;
    }

    @Override
    public void initializeConnectionData(Connection connection) throws SQLException {
        this.driverSupportsNationalCharacterVarying = false;
    }

    @Override
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("BLOB(x'");
            Helper.writeHexString(bytes, writer);
            writer.write("')");
        } else {
            super.appendByteArray(bytes, writer);
        }
    }

    @Override
    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendDB2Date(date, writer);
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendDB2Date(Date date, Writer writer) throws IOException {
        writer.write("'");
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        if (calendar.get(2) + 1 < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(2) + 1));
        writer.write(47);
        if (calendar.get(5) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(5)));
        writer.write(47);
        writer.write(Integer.toString(calendar.get(1)));
        writer.write("'");
        Helper.releaseCalendar(calendar);
    }

    protected void appendDB2Timestamp(Timestamp timestamp, Writer writer) throws IOException {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        writer.write(Helper.printDate(calendar));
        writer.write(45);
        if (calendar.get(11) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(11)));
        writer.write(46);
        if (calendar.get(12) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(12)));
        writer.write(46);
        if (calendar.get(13) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(13)));
        writer.write(46);
        Helper.releaseCalendar(calendar);
        String nanoString = Integer.toString(timestamp.getNanos());
        int numberOfZeros = 0;
        for (int num = Math.min(9 - nanoString.length(), 6); num > 0; --num) {
            writer.write(48);
            ++numberOfZeros;
        }
        if (nanoString.length() + numberOfZeros > 6) {
            nanoString = nanoString.substring(0, 6 - numberOfZeros);
        }
        writer.write(nanoString);
    }

    protected void appendDB2Calendar(Calendar calendar, Writer writer) throws IOException {
        int second;
        int minute;
        int hour;
        if (!Helper.getDefaultTimeZone().equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            hour = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
            Helper.releaseCalendar(localCalendar);
        } else {
            hour = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
        }
        writer.write(Helper.printDate(calendar));
        writer.write(45);
        if (hour < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(hour));
        writer.write(46);
        if (minute < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(minute));
        writer.write(46);
        if (second < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(second));
        writer.write(46);
        String millisString = Integer.toString(calendar.get(14));
        int numberOfZeros = 0;
        for (int num = Math.min(3 - millisString.length(), 3); num > 0; --num) {
            writer.write(48);
            ++numberOfZeros;
        }
        if (millisString.length() + numberOfZeros > 3) {
            millisString = millisString.substring(0, 3 - numberOfZeros);
        }
        writer.write(millisString);
    }

    @Override
    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    @Override
    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            this.appendDB2Timestamp(timestamp, writer);
            writer.write("'");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    @Override
    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            this.appendDB2Calendar(calendar, writer);
            writer.write("'");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    @Override
    protected Hashtable<Class<?>, FieldTypeDefinition> buildFieldTypes() {
        Hashtable fieldTypeMapping = new Hashtable();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("SMALLINT DEFAULT 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DECIMAL", 15));
        if (this.getUseNationalCharacterVaryingTypeForString()) {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255, "FOR MIXED DATA"));
        } else {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        }
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", 64000));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", 64000));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB", 64000));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("CLOB", 64000));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB", 64000));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("CLOB", 64000));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    @Override
    public int getMaxFieldNameSize() {
        return 128;
    }

    @Override
    public int getMaxForeignKeyNameSize() {
        return 18;
    }

    @Override
    public int getMaxUniqueKeyNameSize() {
        return 18;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        Object query = "SELECT * FROM SYSIBM.SYSTABLES WHERE TBCREATOR NOT IN ('SYS', 'SYSTEM')";
        if (table != null) {
            query = table.indexOf(37) != -1 ? (String)query + " AND TBNAME LIKE " + table : (String)query + " AND TBNAME = " + table;
        }
        if (creator != null) {
            query = creator.indexOf(37) != -1 ? (String)query + " AND TBCREATOR LIKE " + creator : (String)query + " AND TBCREATOR = " + creator;
        }
        return session.executeSelectingCall(new SQLCall((String)query));
    }

    @Override
    public String getProcedureCallHeader() {
        return "CALL ";
    }

    @Override
    public String getSelectForUpdateString() {
        return " FOR READ ONLY WITH RS USE AND KEEP UPDATE LOCKS";
    }

    @Override
    public String getProcedureEndString() {
        return "END";
    }

    @Override
    public String getProcedureBeginString() {
        return "BEGIN";
    }

    @Override
    public String getProcedureAsString() {
        return "";
    }

    @Override
    public String getProcedureArgument(String name, Object parameter, DatasourceCall.ParameterType parameterType, StoredProcedureCall call, AbstractSession session) {
        if (name != null && this.shouldPrintStoredProcedureArgumentNameInCall()) {
            return this.getProcedureArgumentString() + name + " => ?";
        }
        return "?";
    }

    @Override
    public boolean shouldPrintOutputTokenAtStart() {
        return true;
    }

    @Override
    public boolean shouldBindPartialParameters() {
        return this.shouldBindPartialParameters;
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT CURRENT TIMESTAMP FROM SYSIBM.SYSDUMMY1");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(28, "UCASE"));
        this.addOperator(ExpressionOperator.simpleFunction(29, "LCASE"));
        this.addOperator(this.count());
        this.addOperator(this.max());
        this.addOperator(this.min());
        this.addOperator(this.concatOperator());
        this.addOperator(this.caseOperator());
        this.addOperator(this.caseConditionOperator());
        this.addOperator(this.distinct());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(34, "Locate"));
        this.addOperator(ExpressionOperator.simpleFunction(42, "DECIMAL"));
        this.addOperator(ExpressionOperator.simpleFunction(114, "CHAR"));
        this.addOperator(ExpressionOperator.simpleFunction(48, "CHAR"));
        this.addOperator(ExpressionOperator.simpleFunction(53, "DATE"));
        this.addOperator(this.ascendingOperator());
        this.addOperator(this.descendingOperator());
        this.addOperator(this.trim2());
        this.addOperator(this.ltrim2Operator());
        this.addOperator(this.rtrim2Operator());
        this.addOperator(this.lengthOperator());
        this.addOperator(this.nullifOperator());
        this.addOperator(this.coalesceOperator());
        this.addOperator(this.roundOperator());
    }

    protected static ExpressionOperator disableAllBindingExpression() {
        return new ExpressionOperator(){

            @Override
            public void printDuo(Expression first, Expression second, ExpressionSQLPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printDuo(first, second, printer);
                    return;
                }
                if (first.isParameterExpression()) {
                    ((ParameterExpression)first).setCanBind(false);
                } else if (first.isConstantExpression()) {
                    ((ConstantExpression)first).setCanBind(false);
                }
                if (second.isParameterExpression()) {
                    ((ParameterExpression)second).setCanBind(false);
                } else if (second.isConstantExpression()) {
                    ((ConstantExpression)second).setCanBind(false);
                }
                super.printDuo(first, second, printer);
            }

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                for (Expression item : items) {
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaDuo(Expression first, Expression second, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaDuo(first, second, printer);
                    return;
                }
                if (first.isParameterExpression()) {
                    ((ParameterExpression)first).setCanBind(false);
                } else if (first.isConstantExpression()) {
                    ((ConstantExpression)first).setCanBind(false);
                }
                if (second.isParameterExpression()) {
                    ((ParameterExpression)second).setCanBind(false);
                } else if (second.isConstantExpression()) {
                    ((ConstantExpression)second).setCanBind(false);
                }
                super.printJavaDuo(first, second, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                for (Expression item : items) {
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printJavaCollection(items, printer);
            }
        };
    }

    protected static ExpressionOperator disableAtLeast1BindingExpression() {
        return new ExpressionOperator(){

            @Override
            public void printDuo(Expression first, Expression second, ExpressionSQLPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printDuo(first, second, printer);
                    return;
                }
                boolean firstBound = true;
                if (second != null) {
                    boolean secondBound = true;
                    if (first.isValueExpression() && second.isValueExpression()) {
                        if (printer.getPlatform().shouldBindLiterals()) {
                            if (first.isConstantExpression() && second.isParameterExpression()) {
                                firstBound = false;
                            } else {
                                secondBound = false;
                            }
                        } else if (first.isParameterExpression() && second.isParameterExpression()) {
                            secondBound = false;
                        }
                    }
                    if (second.isParameterExpression()) {
                        ((ParameterExpression)second).setCanBind(secondBound);
                    } else if (second.isConstantExpression()) {
                        ((ConstantExpression)second).setCanBind(secondBound);
                    }
                }
                if (first.isParameterExpression()) {
                    ((ParameterExpression)first).setCanBind(firstBound);
                } else if (first.isConstantExpression()) {
                    ((ConstantExpression)first).setCanBind(firstBound);
                }
                super.printDuo(first, second, printer);
            }

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                int[] indices = this.getArgumentIndices(items.size());
                boolean allBind = true;
                for (int i = 0; i < items.size(); ++i) {
                    int index = indices[i];
                    Expression item = items.get(index);
                    boolean shouldBind = true;
                    if (!item.isValueExpression()) {
                        allBind = false;
                    }
                    if (allBind) {
                        if (printer.getPlatform().shouldBindLiterals()) {
                            if (i == indices.length - 1) {
                                allBind = false;
                                shouldBind = false;
                            }
                        } else if (item.isConstantExpression()) {
                            allBind = false;
                            shouldBind = false;
                        } else if (i == indices.length - 1 && item.isParameterExpression()) {
                            allBind = false;
                            shouldBind = false;
                        }
                    }
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(shouldBind);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(shouldBind);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaDuo(Expression first, Expression second, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaDuo(first, second, printer);
                    return;
                }
                boolean firstBound = true;
                if (second != null) {
                    boolean secondBound = true;
                    if (first.isValueExpression() && second.isValueExpression()) {
                        if (printer.getPlatform().shouldBindLiterals()) {
                            if (first.isConstantExpression() && second.isParameterExpression()) {
                                firstBound = false;
                            } else {
                                secondBound = false;
                            }
                        } else if (first.isParameterExpression() && second.isParameterExpression()) {
                            secondBound = false;
                        }
                    }
                    if (second.isParameterExpression()) {
                        ((ParameterExpression)second).setCanBind(secondBound);
                    } else if (second.isConstantExpression()) {
                        ((ConstantExpression)second).setCanBind(secondBound);
                    }
                }
                if (first.isParameterExpression()) {
                    ((ParameterExpression)first).setCanBind(firstBound);
                } else if (first.isConstantExpression()) {
                    ((ConstantExpression)first).setCanBind(firstBound);
                }
                super.printJavaDuo(first, second, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                boolean allBind = true;
                for (int i = 0; i < items.size(); ++i) {
                    Expression item = items.get(i);
                    boolean shouldBind = true;
                    if (!item.isValueExpression()) {
                        allBind = false;
                    }
                    if (allBind) {
                        if (printer.getPlatform().shouldBindLiterals()) {
                            if (i == items.size() - 1) {
                                allBind = false;
                                shouldBind = false;
                            }
                        } else if (item.isConstantExpression()) {
                            allBind = false;
                            shouldBind = false;
                        } else if (i == items.size() - 1 && item.isParameterExpression()) {
                            allBind = false;
                            shouldBind = false;
                        }
                    }
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(shouldBind);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(shouldBind);
                }
                super.printJavaCollection(items, printer);
            }
        };
    }

    protected ExpressionOperator ascendingOperator() {
        ExpressionOperator operator = DB2Platform.disableAllBindingExpression();
        ExpressionOperator.ascending().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator descendingOperator() {
        ExpressionOperator operator = DB2Platform.disableAllBindingExpression();
        ExpressionOperator.descending().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator concatOperator() {
        ExpressionOperator operator = new ExpressionOperator();
        operator.setType(5);
        operator.setSelector(31);
        Vector<String> v = new Vector<String>(5);
        v.add("VARCHAR(");
        v.add(" || ");
        v.add(")");
        operator.printsAs(v);
        operator.bePrefix();
        operator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return operator;
    }

    protected ExpressionOperator count() {
        ExpressionOperator operator = DB2Platform.disableAllBindingExpression();
        ExpressionOperator.count().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator max() {
        ExpressionOperator operator = DB2Platform.disableAllBindingExpression();
        ExpressionOperator.maximum().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator min() {
        ExpressionOperator operator = DB2Platform.disableAllBindingExpression();
        ExpressionOperator.minimum().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator distinct() {
        ExpressionOperator operator = DB2Platform.disableAllBindingExpression();
        ExpressionOperator.distinct().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator caseOperator() {
        ListExpressionOperator operator = new ListExpressionOperator(){

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                int j;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                int i = 0;
                int numberOfItems = items.size();
                boolean[] argumentBinding = new boolean[numberOfItems + 1];
                argumentBinding[i] = true;
                ++i;
                boolean[] separatorsBinding = new boolean[]{true, false};
                boolean[] terminationStringsBinding = new boolean[]{false, true};
                while (i < numberOfItems - (terminationStringsBinding.length - 1)) {
                    for (j = 0; j < separatorsBinding.length; ++j) {
                        argumentBinding[i] = separatorsBinding[j];
                        ++i;
                    }
                }
                while (i <= numberOfItems) {
                    for (j = 0; j < terminationStringsBinding.length; ++j) {
                        argumentBinding[i] = terminationStringsBinding[j];
                        ++i;
                    }
                }
                int[] indices = this.getArgumentIndices(items.size());
                for (int j2 = 0; j2 < items.size(); ++j2) {
                    int index = indices[j2];
                    Expression item = items.get(index);
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(argumentBinding[index]);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(argumentBinding[index]);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                int j;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                int i = 0;
                int numberOfItems = items.size();
                boolean[] argumentBinding = new boolean[numberOfItems + 1];
                argumentBinding[i] = true;
                ++i;
                boolean[] separatorsBinding = new boolean[]{true, false};
                boolean[] terminationStringsBinding = new boolean[]{false, true};
                while (i < numberOfItems - (terminationStringsBinding.length - 1)) {
                    for (j = 0; j < separatorsBinding.length; ++j) {
                        argumentBinding[i] = separatorsBinding[j];
                        ++i;
                    }
                }
                while (i <= numberOfItems) {
                    for (j = 0; j < terminationStringsBinding.length; ++j) {
                        argumentBinding[i] = terminationStringsBinding[j];
                        ++i;
                    }
                }
                for (j = 0; j < items.size(); ++j) {
                    Expression item = items.get(j);
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(argumentBinding[j]);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(argumentBinding[j]);
                }
                super.printJavaCollection(items, printer);
            }
        };
        ExpressionOperator.caseStatement().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator caseConditionOperator() {
        ListExpressionOperator operator = new ListExpressionOperator(){

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                int j;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                int i = 0;
                int numberOfItems = items.size();
                boolean[] argumentBinding = new boolean[numberOfItems + 1];
                argumentBinding[i] = true;
                argumentBinding[++i] = false;
                ++i;
                boolean[] separatorsBinding = new boolean[]{true, false};
                boolean[] terminationStringsBinding = new boolean[]{false, true};
                while (i < numberOfItems - (terminationStringsBinding.length - 1)) {
                    for (j = 0; j < separatorsBinding.length; ++j) {
                        argumentBinding[i] = separatorsBinding[j];
                        ++i;
                    }
                }
                while (i <= numberOfItems) {
                    for (j = 0; j < terminationStringsBinding.length; ++j) {
                        argumentBinding[i] = terminationStringsBinding[j];
                        ++i;
                    }
                }
                int[] indices = this.getArgumentIndices(items.size());
                for (int j2 = 0; j2 < items.size(); ++j2) {
                    int index = indices[j2];
                    Expression item = items.get(index);
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(argumentBinding[index]);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(argumentBinding[index]);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                int j;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                int i = 0;
                int numberOfItems = items.size();
                boolean[] argumentBinding = new boolean[numberOfItems + 1];
                argumentBinding[i] = true;
                argumentBinding[++i] = false;
                ++i;
                boolean[] separatorsBinding = new boolean[]{true, false};
                boolean[] terminationStringsBinding = new boolean[]{false, true};
                while (i < numberOfItems - (terminationStringsBinding.length - 1)) {
                    for (j = 0; j < separatorsBinding.length; ++j) {
                        argumentBinding[i] = separatorsBinding[j];
                        ++i;
                    }
                }
                while (i <= numberOfItems) {
                    for (j = 0; j < terminationStringsBinding.length; ++j) {
                        argumentBinding[i] = terminationStringsBinding[j];
                        ++i;
                    }
                }
                for (j = 0; j < items.size(); ++j) {
                    Expression item = items.get(j);
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(argumentBinding[j]);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(argumentBinding[j]);
                }
                super.printJavaCollection(items, printer);
            }
        };
        ExpressionOperator.caseConditionStatement().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator lengthOperator() {
        ExpressionOperator operator = DB2Platform.disableAllBindingExpression();
        ExpressionOperator.length().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator nullifOperator() {
        ExpressionOperator operator = DB2Platform.disableAtLeast1BindingExpression();
        ExpressionOperator.nullIf().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator coalesceOperator() {
        ListExpressionOperator operator = new ListExpressionOperator(){

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                int[] indices = this.getArgumentIndices(items.size());
                boolean allBind = true;
                for (int i = 0; i < items.size(); ++i) {
                    int index = indices[i];
                    Expression item = items.get(index);
                    boolean shouldBind = true;
                    if (!item.isValueExpression()) {
                        allBind = false;
                    }
                    if (allBind) {
                        if (printer.getPlatform().shouldBindLiterals()) {
                            if (i == indices.length - 1) {
                                allBind = false;
                                shouldBind = false;
                            }
                        } else if (item.isConstantExpression()) {
                            allBind = false;
                            shouldBind = false;
                        } else if (i == indices.length - 1 && item.isParameterExpression()) {
                            allBind = false;
                            shouldBind = false;
                        }
                    }
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(shouldBind);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(shouldBind);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                boolean allBind = true;
                for (int i = 0; i < items.size(); ++i) {
                    Expression item = items.get(i);
                    boolean shouldBind = true;
                    if (!item.isValueExpression()) {
                        allBind = false;
                    }
                    if (allBind) {
                        if (printer.getPlatform().shouldBindLiterals()) {
                            if (i == items.size() - 1) {
                                allBind = false;
                                shouldBind = false;
                            }
                        } else if (item.isConstantExpression()) {
                            allBind = false;
                            shouldBind = false;
                        } else if (i == items.size() - 1 && item.isParameterExpression()) {
                            allBind = false;
                            shouldBind = false;
                        }
                    }
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(shouldBind);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(shouldBind);
                }
                super.printJavaCollection(items, printer);
            }
        };
        ExpressionOperator.coalesce().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator trim2() {
        ExpressionOperator operator = new ExpressionOperator(){

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                int[] indices = this.getArgumentIndices(items.size());
                for (int i = 0; i < items.size(); ++i) {
                    int index = indices[i];
                    Expression item = items.get(index);
                    if (i != 0) continue;
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                for (int i = 0; i < items.size(); ++i) {
                    Expression item = items.get(i);
                    if (i != 0) continue;
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printJavaCollection(items, printer);
            }
        };
        operator.setType(5);
        operator.setSelector(121);
        ArrayList<String> v = new ArrayList<String>(3);
        v.add("TRIM(");
        v.add(" FROM ");
        v.add(")");
        operator.printsAs(v);
        operator.bePrefix();
        int[] indices = new int[]{1, 0};
        operator.setArgumentIndices(indices);
        operator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return operator;
    }

    protected ExpressionOperator ltrim2Operator() {
        ExpressionOperator operator = new ExpressionOperator(){

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                int[] indices = this.getArgumentIndices(items.size());
                for (int i = 0; i < items.size(); ++i) {
                    int index = indices[i];
                    Expression item = items.get(index);
                    if (i != 0) continue;
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                for (int i = 0; i < items.size(); ++i) {
                    Expression item = items.get(i);
                    if (i != 0) continue;
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printJavaCollection(items, printer);
            }
        };
        operator.setType(5);
        operator.setSelector(122);
        Vector<String> v = new Vector<String>(5);
        v.add("TRIM(LEADING ");
        v.add(" FROM ");
        v.add(")");
        operator.printsAs(v);
        operator.bePrefix();
        int[] indices = new int[]{1, 0};
        operator.setArgumentIndices(indices);
        operator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return operator;
    }

    protected ExpressionOperator rtrim2Operator() {
        ExpressionOperator operator = new ExpressionOperator(){

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                int[] indices = this.getArgumentIndices(items.size());
                for (int i = 0; i < items.size(); ++i) {
                    int index = indices[i];
                    Expression item = items.get(index);
                    if (i != 0) continue;
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                for (int i = 0; i < items.size(); ++i) {
                    Expression item = items.get(i);
                    if (i != 0) continue;
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printJavaCollection(items, printer);
            }
        };
        operator.setType(5);
        operator.setSelector(116);
        Vector<String> v = new Vector<String>(5);
        v.add("TRIM(TRAILING ");
        v.add(" FROM ");
        v.add(")");
        operator.printsAs(v);
        operator.bePrefix();
        int[] indices = new int[]{1, 0};
        operator.setArgumentIndices(indices);
        operator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return operator;
    }

    protected ExpressionOperator roundOperator() {
        ExpressionOperator operator = DB2Platform.disableAtLeast1BindingExpression();
        ExpressionOperator.round().copyTo(operator);
        return operator;
    }

    @Override
    public boolean isDB2() {
        return true;
    }

    @Override
    public Hashtable<Class<? extends Number>, ? super Number> maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Integer.MAX_VALUE);
        values.put(Float.class, Float.valueOf(1.2345679E8f));
        values.put(Double.class, 3.4028234663852886E38);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(BigInteger.class, new BigInteger("999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("0.999999999999999"));
        return values;
    }

    @Override
    public Hashtable<Class<? extends Number>, ? super Number> minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Integer.MIN_VALUE);
        values.put(Float.class, Float.valueOf(-1.2345679E8f));
        values.put(Double.class, 1.4E-45f);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(BigInteger.class, new BigInteger("-999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-0.999999999999999"));
        return values;
    }

    @Override
    public boolean shouldIgnoreException(SQLException exception) {
        if (exception.getMessage().equals("No data found") || exception.getMessage().equals("No row was found for FETCH, UPDATE or DELETE; or the result of a query is an empty table") || exception.getErrorCode() == 100) {
            return true;
        }
        return super.shouldIgnoreException(exception);
    }

    @Override
    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" GENERATED ALWAYS AS IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    protected void printFieldTypeSize(Writer writer, FieldDefinition field, FieldTypeDefinition ftd) throws IOException {
        super.printFieldTypeSize(writer, field, ftd);
        String suffix = ftd.getTypesuffix();
        if (suffix != null) {
            writer.append(" " + suffix);
        }
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsGlobalTempTables() {
        return true;
    }

    @Override
    protected String getCreateTempTableSqlPrefix() {
        return "DECLARE GLOBAL TEMPORARY TABLE ";
    }

    @Override
    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        DatabaseTable tempTable = super.getTempTableForTable(table);
        tempTable.setTableQualifier("session");
        return tempTable;
    }

    @Override
    protected String getCreateTempTableSqlSuffix() {
        return " ON COMMIT DELETE ROWS NOT LOGGED";
    }

    @Override
    protected String getCreateTempTableSqlBodyForTable(DatabaseTable table) {
        return " LIKE " + table.getQualifiedNameDelimited(this);
    }

    @Override
    public String getNoWaitString() {
        return "";
    }

    @Override
    public boolean dontBindUpdateAllQueryUsingTempTables() {
        return true;
    }

    @Override
    public boolean isNullAllowedInSelectClause() {
        return false;
    }

    @Override
    public boolean isDynamicSQLRequiredForFunctions() {
        if (this.shouldForceBindAllParameters()) {
            return false;
        }
        return !this.isCastRequired();
    }

    @Override
    public boolean allowBindingForSelectClause() {
        return false;
    }

    @Override
    public void writeParameterMarker(Writer writer, ParameterExpression parameter, AbstractRecord record, DatabaseCall call) throws IOException {
        Object paramaterMarker = "?";
        Object type = parameter.getType();
        if (type != null && (this.isCastRequired || call.getQuery() != null && call.getQuery().isUpdateAllQuery())) {
            BasicTypeHelperImpl typeHelper = BasicTypeHelperImpl.getInstance();
            Object castType = null;
            if (typeHelper.isBooleanType(type) || typeHelper.isByteType(type) || typeHelper.isShortType(type)) {
                castType = "SMALLINT";
            } else if (typeHelper.isIntType(type)) {
                castType = "INTEGER";
            } else if (typeHelper.isLongType(type)) {
                castType = "BIGINT";
            } else if (typeHelper.isFloatType(type)) {
                castType = "REAL";
            } else if (typeHelper.isDoubleType(type)) {
                castType = "DOUBLE";
            } else if (typeHelper.isStringType(type)) {
                castType = "VARCHAR(" + this.getCastSizeForVarcharParameter() + ")";
            } else if (typeHelper.isCharacterType(type)) {
                castType = "CHAR";
            }
            if (castType != null) {
                paramaterMarker = "CAST (? AS " + (String)castType + ")";
            }
        }
        writer.write((String)paramaterMarker);
    }

    @Override
    public boolean supportsLockingQueriesWithMultipleTables() {
        return false;
    }

    @Override
    public ValueReadQuery buildSelectQueryForSequenceObject(String qualifiedSeqName, Integer size) {
        return new ValueReadQuery("VALUES(NEXT VALUE FOR " + qualifiedSeqName + ")");
    }

    @Override
    public boolean supportsSequenceObjects() {
        return true;
    }

    @Override
    public boolean supportsOrderByParameters() {
        return false;
    }

    @Override
    public boolean isAlterSequenceObjectSupported() {
        return true;
    }

    @Override
    public boolean shouldPrintForUpdateClause() {
        return false;
    }

    @Override
    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        int max = 0;
        int firstRow = 0;
        if (statement.getQuery() != null) {
            max = statement.getQuery().getMaxRows();
            firstRow = statement.getQuery().getFirstResult();
        }
        if (!this.shouldUseRownumFiltering() || max <= 0 && firstRow <= 0) {
            super.printSQLSelectStatement(call, printer, statement);
            statement.appendForUpdateClause(printer);
            return;
        }
        if (max > 0) {
            statement.setUseUniqueFieldAliases(true);
            printer.printString("SELECT * FROM (SELECT * FROM (SELECT ");
            printer.printString("EL_TEMP.*, ROWNUMBER() OVER() AS EL_ROWNM FROM (");
            call.setFields(statement.printSQL(printer));
            printer.printString(") AS EL_TEMP) AS EL_TEMP2 WHERE EL_ROWNM <= ");
            printer.printParameter(DatabaseCall.MAXROW_FIELD);
            printer.printString(") AS EL_TEMP3 WHERE EL_ROWNM > ");
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
            statement.appendForUpdateClause(printer);
        } else {
            statement.setUseUniqueFieldAliases(true);
            printer.printString("SELECT * FROM (SELECT EL_TEMP.*, ROWNUMBER() OVER() AS EL_ROWNM FROM (");
            call.setFields(statement.printSQL(printer));
            printer.printString(") AS EL_TEMP) AS EL_TEMP2 WHERE EL_ROWNM > ");
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
            statement.appendForUpdateClause(printer);
        }
        call.setIgnoreFirstRowSetting(true);
        call.setIgnoreMaxResultsSetting(true);
    }
}

