/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.core.mappings.CoreAttributeAccessor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class JAXBArrayAttributeAccessor
extends AttributeAccessor {
    private CoreAttributeAccessor nestedAccessor;
    private CoreContainerPolicy containerPolicy;
    private String componentClassName;
    private Class<?> componentClass;
    private String adaptedClassName;
    private Class<? extends ManyValue> adaptedClass;
    private ClassLoader classLoader;

    public JAXBArrayAttributeAccessor(CoreAttributeAccessor nestedAccessor, CoreContainerPolicy containerPolicy, ClassLoader classLoader) {
        this.nestedAccessor = nestedAccessor;
        this.containerPolicy = containerPolicy;
        this.classLoader = classLoader;
    }

    @Override
    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object arrayValue = this.nestedAccessor.getAttributeValueFromObject(object);
        if (arrayValue == null) {
            return null;
        }
        int length = Array.getLength(arrayValue);
        Object results = this.containerPolicy.containerInstance(length);
        if (null == this.adaptedClass) {
            for (int x = 0; x < length; ++x) {
                this.containerPolicy.addInto(Array.get(arrayValue, x), results, null);
            }
        } else {
            for (int x = 0; x < length; ++x) {
                try {
                    ManyValue manyValue = PrivilegedAccessHelper.newInstanceFromClass(this.adaptedClass);
                    manyValue.setItem(Array.get(arrayValue, x));
                    this.containerPolicy.addInto(manyValue, results, null);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return results;
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        Object firstItem;
        List listValue = (List)value;
        if (null == listValue || listValue.isEmpty()) {
            this.nestedAccessor.setAttributeValueInObject(object, null);
            return;
        }
        int listValueSize = listValue.size();
        int[] dims = new int[]{listValueSize};
        if (listValueSize > 0 && (firstItem = listValue.get(0)) instanceof ManyValue) {
            dims = this.getDimensions(dims, ((ManyValue)firstItem).getItem());
        }
        Object arrayValue = Array.newInstance(this.componentClass, dims);
        for (int i = 0; i < listValueSize; ++i) {
            Object next = listValue.get(i);
            if (next instanceof ManyValue) {
                next = ((ManyValue)next).getItem();
            }
            Array.set(arrayValue, i, next);
        }
        this.nestedAccessor.setAttributeValueInObject(object, arrayValue);
    }

    @Override
    public void initializeAttributes(Class<?> theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
        if (this.adaptedClass == null && this.adaptedClassName != null) {
            try {
                this.adaptedClass = PrivilegedAccessHelper.getClassForName(this.adaptedClassName, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.componentClass == null && this.componentClassName != null) {
            try {
                this.componentClass = PrivilegedAccessHelper.getClassForName(this.componentClassName, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setAdaptedClass(Class<? extends ManyValue> adaptedClass) {
        this.adaptedClass = adaptedClass;
    }

    public void setComponentClass(Class<?> componentClass) {
        this.componentClass = componentClass;
    }

    public void setAdaptedClassName(String adaptedClassName) {
        this.adaptedClassName = adaptedClassName;
    }

    public void setComponentClassName(String componentClassName) {
        this.componentClassName = componentClassName;
    }

    private int[] getDimensions(int[] dimensions, Object array) {
        int[] newDimensions = Arrays.copyOf(dimensions, dimensions.length + 1);
        newDimensions[newDimensions.length - 1] = Array.getLength(array);
        Object nestedArray = Array.get(array, 0);
        if (nestedArray.getClass().isArray()) {
            return this.getDimensions(newDimensions, nestedArray);
        }
        return newDimensions;
    }

    public void setNestedAccessor(AttributeAccessor a) {
        this.nestedAccessor = a;
    }

    @Override
    public void setIsWriteOnly(boolean aBoolean) {
        super.setIsWriteOnly(aBoolean);
        this.nestedAccessor.setIsWriteOnly(aBoolean);
    }

    @Override
    public void setIsReadOnly(boolean aBoolean) {
        super.setIsReadOnly(aBoolean);
        this.nestedAccessor.setIsReadOnly(aBoolean);
    }
}

