/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.nosql.adapters.sdk;

import jakarta.resource.cci.Connection;
import java.util.Properties;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLConnectionFactory;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLJCAConnectionSpec;

public class OracleNoSQLConnectionSpec
extends EISConnectionSpec {
    public static String SERVICE = "nosql.service";
    public static String END_POINT = "nosql.endpoint";
    public static String COMPARTMENT = "nosql.compartment";
    public static String AUTHORIZATION_PRINCIPAL = "nosql.authprincipal";

    public Connection connectToDataSource(EISAccessor accessor, Properties properties) throws DatabaseException, ValidationException {
        if (this.connectionFactory == null && this.name == null) {
            this.connectionFactory = new OracleNoSQLConnectionFactory();
        }
        if (!properties.isEmpty()) {
            String authPrincipalType;
            String compartment;
            String endPoint;
            if (this.connectionSpec == null) {
                this.connectionSpec = new OracleNoSQLJCAConnectionSpec();
            }
            OracleNoSQLJCAConnectionSpec spec = (OracleNoSQLJCAConnectionSpec)this.connectionSpec;
            String serviceName = (String)properties.get(SERVICE);
            if (serviceName != null) {
                spec.setService(OracleNoSQLJCAConnectionSpec.ServiceType.get(serviceName).get());
            }
            if ((endPoint = (String)properties.get(END_POINT)) != null) {
                spec.setEndPoint(endPoint);
            }
            if ((compartment = (String)properties.get(COMPARTMENT)) != null) {
                spec.setCompartment(compartment);
            }
            if ((authPrincipalType = (String)properties.get(AUTHORIZATION_PRINCIPAL)) != null) {
                spec.setAuthPrincipalType(OracleNoSQLJCAConnectionSpec.AuthPrincipalType.get(authPrincipalType).get());
            }
        }
        return super.connectToDataSource(accessor, properties);
    }
}

