/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class StoredProcedureTimestampTest
extends TestCase {
    DatabaseRecord row;
    boolean shouldBindAllParameters;

    public StoredProcedureTimestampTest() {
        this(true);
    }

    public StoredProcedureTimestampTest(boolean shouldBindAllParameters) {
        this.shouldBindAllParameters = shouldBindAllParameters;
        this.setName(this.getName() + " bind = " + shouldBindAllParameters);
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test can only be run in Oracle");
        }
    }

    public void test() {
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("StoredProcedure_Timestamp");
        call.addNamedInOutputArgument("CURRENT_DATE");
        DataReadQuery query = new DataReadQuery();
        query.setShouldBindAllParameters(this.shouldBindAllParameters);
        query.setCall((Call)call);
        query.addArgument("CURRENT_DATE");
        Date currentDate = new Date();
        Vector<Date> args = new Vector<Date>(1);
        args.addElement(currentDate);
        this.row = (DatabaseRecord)((Vector)this.getSession().executeQuery((DatabaseQuery)query, args)).firstElement();
    }

    public void verify() {
        if (!this.row.get("CURRENT_DATE").getClass().equals(Timestamp.class)) {
            throw new TestErrorException("Timestamp class not returned for java.util.Date");
        }
    }
}

