/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.Customer;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;

public class MemoryQueryAcrossAggregateCollectionMapping
extends TestCase {
    protected Class<?> cls;
    protected Object object;
    protected Customer customer;
    protected ReadAllQuery queryAll;
    protected ReadAllQuery queryObjects;
    protected ReadObjectQuery queryObject;
    protected List allCustomers;
    protected List customers;

    public MemoryQueryAcrossAggregateCollectionMapping(Class<?> cls) {
        this.cls = cls;
        this.setName(this.getName() + AgentBuilderHelper.getNameInBrackets(cls));
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.customers = new Vector();
        this.queryAll = new ReadAllQuery();
        this.queryAll.setReferenceClass(this.cls);
        this.queryAll.setSelectionCriteria(new ExpressionBuilder().anyOf("customers").get("name").greaterThan((Object)"Alan Greenspan"));
        this.getSession().removeQuery("getAllCustomers");
        this.getSession().addQuery("getAllCustomers", (DatabaseQuery)this.queryAll);
        this.allCustomers = (Vector)this.getSession().executeQuery("getAllCustomers");
        for (int i = 0; i < this.allCustomers.size(); ++i) {
            List eachCustomer = AgentBuilderHelper.getCustomers(this.allCustomers.get(i));
            this.customers.addAll(eachCustomer);
        }
    }

    public void test() {
        this.queryObjects = new ReadAllQuery();
        this.queryObjects.setReferenceClass(this.cls);
        this.queryObjects.checkCacheOnly();
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp = bldr.anyOf("customers").get("name").equal((Object)"Vince Carter");
        this.queryObjects.setSelectionCriteria(exp);
        this.customers = (List)this.getSession().executeQuery((DatabaseQuery)this.queryObjects);
    }
}

