/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.OneToOneQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class ReportItemQueryKeyTest
extends ReportQueryTestCase {
    public ReportItemQueryKeyTest() {
        this.setDescription("Tests recursive behavior of this method, especially when custom query keys are used.");
    }

    @Override
    protected void buildExpectedResults() throws Exception {
    }

    @Override
    protected void setup() throws Exception {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("Test not supported in remote, it needs to modify the server-side session descriptor.");
        }
        super.setup();
        ExpressionBuilder builder = new ExpressionBuilder();
        this.reportQuery = new ReportQuery(builder);
        Expression expression = null;
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("address ids", builder.anyOf("projects").get("teamLeaderX").get("address").get("id"));
        this.reportQuery.setSelectionCriteria(expression);
        ClassDescriptor projectDescriptor = this.getSession().getClassDescriptor(Project.class);
        ExpressionBuilder qkBuilder = new ExpressionBuilder();
        Expression joinExpression = qkBuilder.getField("EMP_ID").equal(qkBuilder.getParameter("LEADER_ID"));
        OneToOneQueryKey customQK = new OneToOneQueryKey();
        customQK.setDescriptor(projectDescriptor);
        customQK.setName("teamLeaderX");
        customQK.setReferenceClass(Employee.class);
        customQK.setJoinCriteria(joinExpression);
        projectDescriptor.addQueryKey((QueryKey)customQK);
    }

    public void reset() {
        ClassDescriptor projectDescriptor = this.getSession().getClassDescriptor(Project.class);
        projectDescriptor.getQueryKeys().remove("teamLeaderX");
    }

    @Override
    public void verify() {
        ReportItem item = (ReportItem)this.reportQuery.getItems().get(0);
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Address.class);
        DatabaseMapping mapping = descriptor.getMappingForAttributeName("id");
        if (item.getMapping() != mapping) {
            throw new TestErrorException("The mapping was not set correctly on the ReportItem: " + item.getMapping());
        }
    }
}

