/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class RefreshObjectTest
extends TestCase {
    public Employee emp1;
    public Employee emp2;

    public RefreshObjectTest() {
        this.setDescription("Test the refresh object call, one to refresh from the database, the other from the server session cache");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        this.emp1 = (Employee)this.getSession().readObject(Employee.class);
        this.emp1.setAddress(null);
        this.getSession().refreshObject((Object)this.emp1);
        this.emp2 = (Employee)this.getSession().readObject(Employee.class);
        this.emp2.setFirstName("FunkyJunky");
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.emp2);
        query.refreshRemoteIdentityMapResult();
        query.cascadePrivateParts();
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        if (this.emp1.getAddress() == null) {
            throw new TestErrorException("The address field was still NULL after refresh");
        }
        if (this.emp2.getFirstName().equals("FunkyJunky")) {
            throw new TestErrorException("RemoteSession refresh from the database fails");
        }
    }
}

