/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.io.IOException;
import java.util.logging.Logger;
import oracle.kv.impl.api.AsyncRequestHandler;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.Response;
import oracle.kv.impl.async.AsyncVersionedRemoteDialogInitiator;
import oracle.kv.impl.async.AsyncVersionedRemoteInitiator;
import oracle.kv.impl.async.CreatorEndpoint;
import oracle.kv.impl.async.DialogType;
import oracle.kv.impl.async.MessageInput;
import oracle.kv.impl.async.MessageOutput;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.async.StandardDialogTypeFamily;

class AsyncRequestHandlerInitiator
extends AsyncVersionedRemoteInitiator
implements AsyncRequestHandler {
    AsyncRequestHandlerInitiator(CreatorEndpoint endpoint, DialogType dialogType, Logger logger) {
        super(endpoint, dialogType, logger);
        if (dialogType.getDialogTypeFamily() != StandardDialogTypeFamily.ASYNC_REQUEST_HANDLER) {
            throw new IllegalArgumentException("Dialog type should have dialog type family ASYNC_REQUEST_HANDLER, found: " + dialogType.getDialogTypeFamily());
        }
    }

    @Override
    public void getSerialVersion(short serialVersion, long timeoutMillis, ResultHandler<Short> handler) {
        this.getSerialVersion(serialVersion, AsyncRequestHandler.RequestMethodOp.GET_SERIAL_VERSION, timeoutMillis, handler);
    }

    @Override
    public void execute(final Request request, final long timeoutMillis, final ResultHandler<Response> resultHandler) {
        short serialVersion = request.getSerialVersion();
        final MessageOutput out = this.startRequest(AsyncRequestHandler.RequestMethodOp.EXECUTE, serialVersion);
        try {
            request.writeFastExternal(out, serialVersion);
        }
        catch (IOException e) {
            resultHandler.onResult(null, new RuntimeException("Unexpected problem writing request: " + e, e));
        }
        class ExecuteDialogHandler
        extends AsyncVersionedRemoteDialogInitiator<Response> {
            ExecuteDialogHandler() {
                super(messageOutput, AsyncRequestHandlerInitiator.this.logger, resultHandler2);
            }

            @Override
            public Response readResult(MessageInput in, short responseSerialVersion) throws IOException {
                return new Response(in, responseSerialVersion);
            }

            public String toString() {
                return "Handler[dialogType=" + AsyncRequestHandlerInitiator.this.dialogType + " methodOp=" + AsyncRequestHandler.RequestMethodOp.EXECUTE + " request=(" + request + ") timeoutMillis=" + timeoutMillis + "]";
            }
        }
        this.startDialog(new ExecuteDialogHandler(), timeoutMillis);
    }
}

