/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.KVStore;
import oracle.kv.KVVersion;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationFactory;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.avro.AvroSchemaMetadata;
import oracle.kv.impl.api.avro.AvroSchemaStatus;
import oracle.kv.impl.api.avro.SchemaData;
import org.apache.avro.Schema;

class SchemaAccessor {
    static final int FIRST_SCHEMA_ID = 1;
    private static final int MAX_WRITE_RETRIES = 100;
    private static final String KEY_TAG = "sch";
    private static final Key ROOT_PARENT_KEY = Key.createKey(Arrays.asList("", "sch"));
    private static final Key ACTIVE_PARENT_KEY = Key.createKey(ROOT_PARENT_KEY.getMajorPath(), AvroSchemaStatus.ACTIVE.getCode());
    private static final String ID_FORMAT = "%08x";
    private static final long CONSISTENCY_LAG_MS_1 = 300000L;
    private static final long CONSISTENCY_LAG_MS_2 = 30000L;
    private static final int CONSISTENCY_TIMEOUT_MS = 1;
    private static final short FORMAT_VERSION_1 = -1;
    private static final KVVersion FORMAT_VERSION_1_COMPARE = KVVersion.R3_0;
    private final KVStore store;
    private final List<Consistency> consistencyRamp;

    SchemaAccessor(KVStore store) {
        this.store = KVStoreImpl.makeInternalHandle(store);
        this.consistencyRamp = new ArrayList<Consistency>(4);
        this.consistencyRamp.add(Consistency.NONE_REQUIRED);
        this.consistencyRamp.add(this.createTimeConsistency(300000L));
        this.consistencyRamp.add(this.createTimeConsistency(30000L));
        this.consistencyRamp.add(Consistency.ABSOLUTE);
    }

    private Consistency.Time createTimeConsistency(long lagMs) {
        return new Consistency.Time(lagMs, TimeUnit.MILLISECONDS, 1L, TimeUnit.MILLISECONDS);
    }

    int insertSchema(SchemaData data, KVVersion version) {
        Value value = this.schemaDataToValue(data, version);
        OperationFactory opFactory = this.store.getOperationFactory();
        OperationExecutionException lastOpException = null;
        for (int i = 0; i < 100; ++i) {
            int id;
            ArrayList<Operation> ops = new ArrayList<Operation>(2);
            ValueVersion rootVv = this.store.get(ROOT_PARENT_KEY, Consistency.ABSOLUTE, 0L, null);
            if (rootVv == null) {
                id = 1;
                ops.add(opFactory.createPutIfAbsent(ROOT_PARENT_KEY, this.schemaIdToValue(id), null, true));
            } else {
                id = this.valueToSchemaId(rootVv.getValue()) + 1;
                ops.add(opFactory.createPutIfVersion(ROOT_PARENT_KEY, this.schemaIdToValue(id), rootVv.getVersion(), null, true));
            }
            ops.add(opFactory.createPutIfAbsent(this.schemaIdToKey(id, data.getMetadata().getStatus()), value, null, true));
            try {
                this.store.execute(ops, Durability.COMMIT_SYNC, 0L, null);
                return id;
            }
            catch (OperationExecutionException e) {
                lastOpException = e;
                continue;
            }
        }
        throw new IllegalStateException("Max retries (100) exceeded attempting to insert schema", lastOpException);
    }

    boolean updateSchemaStatus(int schemaId, AvroSchemaMetadata newMeta, KVVersion version) {
        AvroSchemaStatus newStatus = newMeta.getStatus();
        OperationFactory opFactory = this.store.getOperationFactory();
        OperationExecutionException lastOpException = null;
        block2: for (int i = 0; i < 100; ++i) {
            for (AvroSchemaStatus status : AvroSchemaStatus.ALL) {
                Key key = this.schemaIdToKey(schemaId, status);
                ValueVersion vv = this.store.get(key, Consistency.ABSOLUTE, 0L, null);
                if (vv == null) continue;
                if (status == newStatus) {
                    return false;
                }
                Key newKey = this.schemaIdToKey(schemaId, newStatus);
                SchemaData oldData = this.valueToSchemaData(vv.getValue(), status);
                SchemaData newData = new SchemaData(newMeta, oldData.getSchema());
                Value newValue = this.schemaDataToValue(newData, version);
                ArrayList<Operation> ops = new ArrayList<Operation>(2);
                ops.add(opFactory.createDeleteIfVersion(key, vv.getVersion(), null, true));
                ops.add(opFactory.createPutIfAbsent(newKey, newValue, null, true));
                try {
                    this.store.execute(ops, Durability.COMMIT_SYNC, 0L, null);
                    return true;
                }
                catch (OperationExecutionException e) {
                    lastOpException = e;
                    continue block2;
                }
            }
            throw new IllegalArgumentException("Schema ID " + schemaId + " does not exist");
        }
        throw new IllegalStateException("Max retries (100) exceeded attempting to insert schema", lastOpException);
    }

    SortedMap<Integer, SchemaData> readAllSchemas(boolean includeDisabled, Consistency consistency) {
        if (includeDisabled) {
            return this.readSchemas(ROOT_PARENT_KEY, null, consistency);
        }
        return this.readSchemas(ACTIVE_PARENT_KEY, null, consistency);
    }

    SortedMap<Integer, SchemaData> readActiveSchemas(int startSchemaId, boolean includeStart, Consistency consistency) {
        KeyRange subRange = new KeyRange(String.format(ID_FORMAT, startSchemaId), includeStart, null, false);
        return this.readSchemas(ACTIVE_PARENT_KEY, subRange, consistency);
    }

    private SortedMap<Integer, SchemaData> readSchemas(Key parentKey, KeyRange subRange, Consistency consistency) {
        TreeMap<Integer, SchemaData> results = new TreeMap<Integer, SchemaData>();
        Iterator<KeyValueVersion> iter = this.store.multiGetIterator(Direction.FORWARD, 0, parentKey, subRange, Depth.DESCENDANTS_ONLY, consistency, 0L, null);
        while (iter.hasNext()) {
            KeyValueVersion kvv = iter.next();
            int id = this.keyToSchemaId(kvv.getKey());
            AvroSchemaStatus status = this.keyToSchemaStatus(kvv.getKey());
            SchemaData data = this.valueToSchemaData(kvv.getValue(), status);
            results.put(id, data);
        }
        return results;
    }

    SchemaData readSchema(int schemaId, Consistency consistency) {
        for (AvroSchemaStatus status : AvroSchemaStatus.ALL) {
            ValueVersion vv = this.store.get(this.schemaIdToKey(schemaId, status), consistency, 0L, null);
            if (vv == null) continue;
            return this.valueToSchemaData(vv.getValue(), status);
        }
        throw new IllegalArgumentException("Schema ID " + schemaId + " does not exist");
    }

    void deleteAllSchemas() {
        this.store.multiDelete(ROOT_PARENT_KEY, null, Depth.DESCENDANTS_ONLY, Durability.COMMIT_SYNC, 0L, null);
    }

    Iterable<Consistency> getConsistencyRamp() {
        return this.consistencyRamp;
    }

    Consistency getLowestConsistency() {
        return this.consistencyRamp.get(0);
    }

    Consistency getHighestConsistency() {
        return this.consistencyRamp.get(this.consistencyRamp.size() - 1);
    }

    private Key schemaIdToKey(int id, AvroSchemaStatus status) {
        List<String> minorPath = Arrays.asList(status.getCode(), String.format(ID_FORMAT, id));
        return Key.createKey(ROOT_PARENT_KEY.getMajorPath(), minorPath);
    }

    private int keyToSchemaId(Key key) {
        List<String> minor = key.getMinorPath();
        if (minor.size() == 2) {
            try {
                return Integer.parseInt(minor.get(1), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Invalid internal schema key: " + key);
    }

    private AvroSchemaStatus keyToSchemaStatus(Key key) {
        AvroSchemaStatus status;
        List<String> minor = key.getMinorPath();
        if (minor.size() == 2 && (status = AvroSchemaStatus.fromCode(minor.get(0))) != null) {
            return status;
        }
        throw new IllegalStateException("Invalid internal schema key: " + key);
    }

    private Value schemaDataToValue(SchemaData data, KVVersion version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        DataOutputStream dos = new DataOutputStream(baos);
        AvroSchemaMetadata metadata = data.getMetadata();
        try {
            SchemaAccessor.writeLongString(dos, data.getSchema().toString(), version);
            long time = metadata.getTimeModified() != 0L ? metadata.getTimeModified() : System.currentTimeMillis();
            dos.writeLong(time);
            dos.writeUTF(metadata.getByUser());
            dos.writeUTF(metadata.getFromMachine());
            dos.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return Value.createValue(baos.toByteArray());
    }

    private SchemaData valueToSchemaData(Value value, AvroSchemaStatus status) {
        Schema schema;
        String fromMachine;
        String byUser;
        long timeModified;
        String text;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(value.getValue()));
        try {
            text = SchemaAccessor.readLongString(dis);
            timeModified = dis.readLong();
            byUser = dis.readUTF();
            fromMachine = dis.readUTF();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            schema = new Schema.Parser().parse(text);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot parse stored schema: " + text);
        }
        AvroSchemaMetadata metadata = new AvroSchemaMetadata(status, timeModified, byUser, fromMachine);
        return new SchemaData(metadata, schema);
    }

    private Value schemaIdToValue(int id) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(id);
            dos.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return Value.createValue(baos.toByteArray());
    }

    private int valueToSchemaId(Value value) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(value.getValue()));
        try {
            return dis.readInt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static void writeLongString(DataOutputStream out, String str, KVVersion version) throws IOException {
        if (version.compareTo(FORMAT_VERSION_1_COMPARE) < 0) {
            if (str != null && str.length() > Short.MAX_VALUE) {
                throw new IllegalArgumentException("String length too long for serialization in this version, please upgrade to next version.");
            }
            out.writeUTF(str);
        } else {
            out.writeShort(-1);
            byte[] utf = str.getBytes("UTF8");
            out.writeInt(utf.length);
            out.write(utf);
        }
    }

    static String readLongString(DataInputStream in) throws IOException {
        short shortLength = in.readShort();
        if (shortLength >= 0) {
            byte[] utf = new byte[shortLength];
            in.readFully(utf);
            return new String(utf, "UTF8");
        }
        if (shortLength == -1) {
            int len = in.readInt();
            byte[] utf = new byte[len];
            in.readFully(utf);
            return new String(utf, "UTF8");
        }
        throw new IllegalStateException("Unknown format version.");
    }
}

