/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.kv.impl.async.DialogTypeFamily;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class DialogType
implements FastExternalizable {
    public static final int MAX_TYPE_FAMILIES = 100;
    private static int nextTypeNumber = 1;
    private static final Map<Integer, DialogTypeFamily> familyMap = Collections.synchronizedMap(new HashMap());
    private final int dialogTypeId;
    private final DialogTypeFamily dialogTypeFamily;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogType(int dialogTypeId) {
        DialogTypeFamily family;
        if (dialogTypeId < 0) {
            throw new IllegalArgumentException("DialogTypeId must not be less than 0");
        }
        this.dialogTypeId = dialogTypeId;
        int familyId = dialogTypeId % 100;
        Map<Integer, DialogTypeFamily> map = familyMap;
        synchronized (map) {
            family = familyMap.get(familyId);
        }
        if (family == null) {
            throw new IllegalArgumentException("Dialog type family not found for dialogTypeId=" + dialogTypeId + " familyId=" + familyId);
        }
        assert (family.getFamilyId() == familyId);
        this.dialogTypeFamily = family;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogType(DialogTypeFamily dialogTypeFamily) {
        int typeNumber;
        this.dialogTypeFamily = ObjectUtil.checkNull("dialogTypeFamily", dialogTypeFamily);
        int familyId = dialogTypeFamily.getFamilyId();
        if (!familyMap.containsKey(familyId)) {
            throw new IllegalArgumentException("Dialog type family was not registered: " + dialogTypeFamily);
        }
        Map<Integer, DialogTypeFamily> map = familyMap;
        synchronized (map) {
            typeNumber = nextTypeNumber++;
        }
        this.dialogTypeId = typeNumber * 100 + familyId;
    }

    DialogType(int dialogTypeId, DialogTypeFamily dialogTypeFamily) {
        if (dialogTypeId < 0) {
            throw new IllegalArgumentException("DialogTypeId must not be less than 0");
        }
        this.dialogTypeId = dialogTypeId;
        this.dialogTypeFamily = ObjectUtil.checkNull("dialogTypeFamily", dialogTypeFamily);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTypeFamily(DialogTypeFamily dialogTypeFamily) {
        ObjectUtil.checkNull("dialogTypeFamily", dialogTypeFamily);
        Integer familyId = dialogTypeFamily.getFamilyId();
        if (familyId < 0 || familyId >= 100) {
            throw new IllegalArgumentException("Illegal dialog type family ID: " + familyId);
        }
        Map<Integer, DialogTypeFamily> map = familyMap;
        synchronized (map) {
            if (familyMap.containsKey(familyId)) {
                throw new IllegalArgumentException("Existing entry for " + familyId + ": " + familyMap.get(familyId));
            }
            familyMap.put(familyId, dialogTypeFamily);
        }
    }

    public int getDialogTypeId() {
        return this.dialogTypeId;
    }

    public DialogTypeFamily getDialogTypeFamily() {
        return this.dialogTypeFamily;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writePackedInt(out, this.dialogTypeId);
    }

    public static DialogType readFastExternal(DataInput in, short serialVersion) throws IOException {
        return new DialogType(SerializationUtil.readPackedInt(in));
    }

    public String toString() {
        return String.format("%s(%d)", this.dialogTypeFamily.getFamilyName(), this.dialogTypeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DialogType)) {
            return false;
        }
        DialogType other = (DialogType)o;
        return this.dialogTypeId == other.dialogTypeId;
    }

    public int hashCode() {
        return this.dialogTypeId;
    }
}

