/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.fault;

import com.sleepycat.je.EnvironmentFailureException;
import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.MetadataNotFoundException;
import oracle.kv.impl.api.table.TableVersionException;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.fault.WrappedClientException;
import oracle.kv.impl.query.QueryRuntimeException;
import oracle.kv.impl.rep.EnvironmentFailureRetryException;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.server.LoggerUtils;

public class ServiceFaultHandler
extends ProcessFaultHandler {
    private final ConfigurableService service;
    private Throwable shutdownFault;

    public ServiceFaultHandler(ConfigurableService service, Logger logger, ProcessExitCode defaultExitCode) {
        super(logger, defaultExitCode);
        this.service = service;
    }

    @Override
    protected void queueShutdownInternal(Throwable fault, ProcessExitCode exitCode) {
        assert (fault != null);
        this.shutdownFault = fault;
        if (TestStatus.isActive()) {
            new AsyncTestShutdownThread().start();
        } else {
            new AsyncShutdownThread(exitCode).start();
        }
    }

    @Override
    protected RuntimeException getThrowException(RuntimeException requestException) {
        if (requestException instanceof RNUnavailableException || requestException instanceof WrappedClientException || requestException instanceof FaultException) {
            return requestException;
        }
        if (requestException instanceof SessionAccessException) {
            return requestException;
        }
        if (requestException instanceof KVSecurityException || requestException instanceof MetadataNotFoundException) {
            return new WrappedClientException(requestException);
        }
        if (requestException instanceof ClientAccessException) {
            return ((ClientAccessException)requestException).getCause();
        }
        if (requestException instanceof EnvironmentFailureRetryException) {
            return new RNUnavailableException(requestException.getMessage());
        }
        if (requestException instanceof QueryRuntimeException) {
            return this.getThrowException((RuntimeException)requestException.getCause());
        }
        if (requestException instanceof TableVersionException) {
            return new FaultException("Store is updating table schema information; operation should be retried", true);
        }
        return new FaultException(requestException, true);
    }

    @Override
    public ProcessExitCode getExitCode(RuntimeException requestException, ProcessExitCode exitCode) {
        if (requestException instanceof EnvironmentFailureException && ((EnvironmentFailureException)requestException).isCorrupted()) {
            return ProcessExitCode.NO_RESTART;
        }
        if (requestException instanceof RNUnavailableException || requestException instanceof WrappedClientException || requestException instanceof FaultException) {
            return null;
        }
        return exitCode;
    }

    public Throwable getShutdownFault() {
        return this.shutdownFault;
    }

    private class AsyncShutdownThread
    extends Thread {
        final ProcessExitCode exitCode;

        AsyncShutdownThread(ProcessExitCode exitCode) {
            this.exitCode = exitCode;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Thread.yield();
            try {
                System.err.println("Process exiting due to fault");
                if (ServiceFaultHandler.this.shutdownFault != null) {
                    ServiceFaultHandler.this.shutdownFault.printStackTrace(System.err);
                }
                ConfigurableService.ServiceStatus status = ProcessExitCode.NO_RESTART.getValue() == this.exitCode.getValue() ? ConfigurableService.ServiceStatus.ERROR_NO_RESTART : ConfigurableService.ServiceStatus.ERROR_RESTARTING;
                ServiceFaultHandler.this.service.update(status);
                LoggerUtils.closeAllHandlers();
                System.err.flush();
            }
            finally {
                System.exit(this.exitCode.getValue());
            }
        }
    }

    private class AsyncTestShutdownThread
    extends Thread {
        AsyncTestShutdownThread() {
            assert (ServiceFaultHandler.this.service.getUsingThreads());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                ServiceFaultHandler.this.service.stop(true);
            }
            catch (Exception e) {
                System.err.println("Exception during exit: " + e);
            }
        }
    }
}

