/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.measurement;

import java.io.Serializable;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FormatUtils;

public class ServiceStatusChange
implements Measurement,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final ConfigurableService.ServiceStatus newStatus;
    protected long now;

    public ServiceStatusChange(ConfigurableService.ServiceStatus newStatus) {
        this.newStatus = newStatus;
        this.now = System.currentTimeMillis();
    }

    @Override
    public int getId() {
        return Metrics.SERVICE_STATUS.getId();
    }

    public ConfigurableService.ServiceStatus getStatus() {
        return this.newStatus;
    }

    public long getTimeStamp() {
        return this.now;
    }

    public void updateTime() {
        this.now = System.currentTimeMillis();
    }

    public void updateTime(long time) {
        this.now = time;
    }

    public String toString() {
        return "Service status: " + (Object)((Object)this.newStatus) + " " + FormatUtils.formatDateAndTime(this.now);
    }

    @Override
    public long getStart() {
        return this.now;
    }

    @Override
    public long getEnd() {
        return this.now;
    }

    public ResourceId getTarget(ResourceId reportingResource) {
        return reportingResource;
    }
}

