/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.sklogger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.util.sklogger.Metric;
import oracle.kv.impl.util.sklogger.MetricFamilySamples;
import oracle.kv.impl.util.sklogger.StatsData;

public class CustomGauge
extends Metric<GaugeCalculator> {
    private static final List<String> EMPTY_LABEL_VALUES = Arrays.asList(new String[0]);
    private final GaugeCalculator gaugeCalculator;

    public CustomGauge(String name, GaugeCalculator gaugeCalculator) {
        super(name, new String[0]);
        this.gaugeCalculator = gaugeCalculator;
    }

    @Override
    protected GaugeCalculator newElement() {
        return this.gaugeCalculator;
    }

    public List<GaugeResult> getValuesList() {
        try {
            return this.gaugeCalculator.getValuesList();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public MetricFamilySamples<GaugeResult> collect() {
        List<GaugeResult> gaugeResultList = null;
        try {
            gaugeResultList = this.gaugeCalculator.getValuesList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gaugeResultList == null) {
            return null;
        }
        ArrayList samples = new ArrayList(gaugeResultList.size());
        for (GaugeResult e : gaugeResultList) {
            samples.add(new MetricFamilySamples.Sample<GaugeResult>(EMPTY_LABEL_VALUES, e));
        }
        return new MetricFamilySamples<GaugeResult>(this.statsName, StatsData.Type.CUSTOM_GAUGE, this.labelNames, samples);
    }

    public static class GaugeResult
    extends Metric.Result {
        private static final long serialVersionUID = 1L;
        private Map<String, Object> map;

        public GaugeResult(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public Map<String, Object> toMap() {
            return this.map;
        }
    }

    public static interface GaugeCalculator
    extends Metric.Element {
        public List<GaugeResult> getValuesList();
    }
}

