/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.beans;

import java.util.Hashtable;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;

public class ExpressionNode {
    protected static String Equals = "(=) Equals";
    protected static String NotEquals = "(!=) Not Equals";
    protected static String LessThan = "(<) Less Than";
    protected static String LessThanEqual = "(<=) Less Than Equal";
    protected static String GreaterThan = "(>) Greater Than";
    protected static String GreaterThanEqual = "(>=) Greater Than Equal";
    protected static String Like = "Like";
    protected static String NotLike = "Not Like";
    protected static String In = "In";
    protected static String NotIn = "Not In";
    protected static String Between = "Between";
    protected static String NotBetween = "Not Between";
    protected static String Or = "Or";
    protected static String And = "And";
    protected static String Not = "Not";
    protected static String Upper = "Upper Case";
    protected static String Lower = "Lower Case";
    protected static String KeyWordAll = "All Key Words";
    protected static String KeyWordAny = "Any Key Words";
    protected static Hashtable<Integer, String> operators;
    protected static Hashtable<String, String> methods;
    protected Expression expression;

    public ExpressionNode(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public static String getMethod(String method) {
        return ExpressionNode.getMethods().get(method);
    }

    public static Hashtable<String, String> getMethods() {
        if (methods == null) {
            methods = new Hashtable();
            methods.put(Equals, "equal");
            methods.put(NotEquals, "notEqual");
            methods.put(LessThan, "lessThan");
            methods.put(LessThanEqual, "lessThanEqual");
            methods.put(GreaterThan, "greaterThan");
            methods.put(GreaterThanEqual, "greaterThanEqual");
            methods.put(Like, "like");
            methods.put(NotLike, "notLike");
            methods.put(In, "in");
            methods.put(NotIn, "notIn");
            methods.put(Between, "between");
            methods.put(NotBetween, "notBetween");
            methods.put(Or, "or");
            methods.put(And, "and");
            methods.put(Not, "not");
            methods.put(Lower, "toLowerCase");
            methods.put(Upper, "toUpperCase");
            methods.put(KeyWordAny, "containsAnyKeyWords");
            methods.put(KeyWordAll, "containsAllKeyWords");
        }
        return methods;
    }

    public static String getOperator(int anOperator) {
        return ExpressionNode.getOperators().get(anOperator);
    }

    public static Hashtable<Integer, String> getOperators() {
        if (operators == null) {
            operators = new Hashtable();
            operators.put(4, Equals);
            operators.put(5, NotEquals);
            operators.put(7, LessThan);
            operators.put(8, LessThanEqual);
            operators.put(9, GreaterThan);
            operators.put(10, GreaterThanEqual);
            operators.put(11, Like);
            operators.put(12, NotLike);
            operators.put(13, In);
            operators.put(14, NotIn);
            operators.put(15, Between);
            operators.put(16, NotBetween);
            operators.put(2, Or);
            operators.put(1, And);
            operators.put(3, Not);
            operators.put(29, Lower);
            operators.put(28, Upper);
        }
        return operators;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public String toString() {
        if (this.getExpression() == null) {
            return "True";
        }
        if (this.getExpression() instanceof ConstantExpression) {
            return ((ConstantExpression)this.getExpression()).getValue().toString();
        }
        if (this.getExpression() instanceof QueryKeyExpression) {
            return this.getExpression().getName();
        }
        String anOperator = ExpressionNode.getOperator(this.getExpression().getOperator().getSelector());
        if (anOperator == null) {
            return this.getExpression().getOperator().toString();
        }
        return anOperator;
    }
}

