/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.history;

import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.history.HistoricalSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class HistoryFacade {
    private static Map<Session, Long> timeOffsetsMap = new IdentityHashMap<Session, Long>();

    protected HistoryFacade() {
    }

    protected static void buildHistoricalTableDefinition(HistoryPolicy policy, String name, TableDefinition def, TableCreator creator) {
        if (def == null) {
            return;
        }
        TableDefinition histDef = (TableDefinition)def.clone();
        histDef.setName(name);
        FieldDefinition fieldDef = new FieldDefinition();
        fieldDef.setName(policy.getStartFieldName());
        fieldDef.setType(ClassConstants.TIMESTAMP);
        fieldDef.setSize(6);
        histDef.addField(fieldDef);
        fieldDef = new FieldDefinition();
        fieldDef.setName(policy.getEndFieldName());
        fieldDef.setType(ClassConstants.TIMESTAMP);
        fieldDef.setSize(6);
        histDef.addField(fieldDef);
        histDef.setForeignKeys(new Vector());
        for (FieldDefinition fieldDef2 : histDef.getFields()) {
            fieldDef2.setForeignKeyFieldName(null);
            if (fieldDef2.getName().equals("ROW_START") && !histDef.getPrimaryKeyFieldNames().isEmpty()) {
                fieldDef2.setIsPrimaryKey(true);
            }
            if (!fieldDef2.getName().equals("VERSION") || histDef.getPrimaryKeyFieldNames().isEmpty()) continue;
            fieldDef2.setIsPrimaryKey(true);
        }
        creator.addTableDefinition(histDef);
    }

    public static long currentDatabaseTimeMillis(Session session) {
        return HistoryFacade.currentDatabaseTimeMillis(session, null);
    }

    public static long currentDatabaseTimeMillis(Session session, Class<?> domainClass) {
        Session rootSession = session;
        while (rootSession.isUnitOfWork() || rootSession.isClientSession() || rootSession instanceof HistoricalSession || rootSession.isSessionBroker()) {
            if (rootSession.isUnitOfWork()) {
                rootSession = ((UnitOfWork)rootSession).getParent();
                continue;
            }
            if (rootSession.isClientSession()) {
                rootSession = ((ClientSession)rootSession).getParent();
                continue;
            }
            if (rootSession instanceof HistoricalSession) {
                rootSession = ((HistoricalSession)rootSession).getParent();
                continue;
            }
            SessionBroker broker = (SessionBroker)rootSession;
            if ((rootSession = broker.getSessionForClass(domainClass)) != broker) continue;
            break;
        }
        if (timeOffsetsMap.containsKey(rootSession)) {
            Long offset = timeOffsetsMap.get(rootSession);
            return System.currentTimeMillis() + offset;
        }
        ValueReadQuery query = rootSession.getPlatform().getTimestampQuery();
        long startTime = System.currentTimeMillis();
        Timestamp databaseTime = (Timestamp)rootSession.executeQuery((DatabaseQuery)query);
        long endTime = System.currentTimeMillis();
        long jvmTime = (endTime - startTime) / 2L + startTime;
        long offset = databaseTime.getTime() - jvmTime;
        timeOffsetsMap.put(rootSession, offset);
        return jvmTime + offset;
    }

    public static void generateHistoricalTableDefinitions(TableCreator creator, Session session) {
        HashMap<String, TableDefinition> tableDefinitions = new HashMap<String, TableDefinition>(creator.getTableDefinitions().size());
        for (TableDefinition def : creator.getTableDefinitions()) {
            tableDefinitions.put(def.getFullName(), def);
        }
        HashSet<String> generatedTables = new HashSet<String>();
        for (ClassDescriptor descriptor : session.getDescriptors().values()) {
            HistoryPolicy policy = descriptor.getHistoryPolicy();
            if (policy != null) {
                List names = policy.getHistoryTableNames();
                for (int i = 0; i < descriptor.getTableNames().size(); ++i) {
                    String name = (String)descriptor.getTableNames().get(i);
                    String histName = (String)names.get(i);
                    if (generatedTables.contains(histName)) continue;
                    generatedTables.add(histName);
                    TableDefinition def = (TableDefinition)tableDefinitions.get(name);
                    HistoryFacade.buildHistoricalTableDefinition(policy, histName, def, creator);
                }
            }
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                DirectCollectionMapping dcMapping;
                TableDefinition def;
                String histName;
                String name;
                if (mapping.isManyToManyMapping()) {
                    ManyToManyMapping m2mMapping = (ManyToManyMapping)mapping;
                    policy = m2mMapping.getHistoryPolicy();
                    if (policy == null) continue;
                    name = m2mMapping.getRelationTableName();
                    histName = (String)policy.getHistoryTableNames().get(0);
                    if (generatedTables.contains(histName)) continue;
                    generatedTables.add(histName);
                    def = (TableDefinition)tableDefinitions.get(name);
                    HistoryFacade.buildHistoricalTableDefinition(policy, histName, def, creator);
                    continue;
                }
                if (!mapping.isDirectCollectionMapping() || (policy = (dcMapping = (DirectCollectionMapping)mapping).getHistoryPolicy()) == null) continue;
                name = dcMapping.getReferenceTableName();
                histName = (String)policy.getHistoryTableNames().get(0);
                if (generatedTables.contains(histName)) continue;
                generatedTables.add(histName);
                def = (TableDefinition)tableDefinitions.get(name);
                HistoryFacade.buildHistoricalTableDefinition(policy, histName, def, creator);
            }
        }
    }

    public static void generateHistoryPolicies(Iterator<ClassDescriptor> descriptors, DatasourcePlatform platform) {
        HistoryPolicy basePolicy = new HistoryPolicy();
        basePolicy.addStartFieldName("ROW_START");
        basePolicy.addEndFieldName("ROW_END");
        HistoryPolicy policy = null;
        while (descriptors.hasNext()) {
            ClassDescriptor descriptor = descriptors.next();
            policy = (HistoryPolicy)basePolicy.clone();
            Vector tables = descriptor.getTables();
            int size = tables.size();
            if (size == 0) continue;
            for (int i = 0; i < size; ++i) {
                DatabaseTable table = (DatabaseTable)tables.get(i);
                String name = table.getQualifiedNameDelimited(platform);
                String historicalName = table.shouldUseDelimiters() ? name.substring(0, name.length() - 1) + "_HIST" + Helper.getDefaultEndDatabaseDelimiter() : name + "_HIST";
                policy.addHistoryTableName(name, historicalName);
            }
            descriptor.setHistoryPolicy(policy);
            Enumeration mappings = descriptor.getMappings().elements();
            while (mappings.hasMoreElements()) {
                DatabaseMapping mapping = (DatabaseMapping)mappings.nextElement();
                if (mapping instanceof ManyToManyMapping) {
                    ManyToManyMapping m2mMapping = (ManyToManyMapping)mapping;
                    policy = (HistoryPolicy)basePolicy.clone();
                    policy.addHistoryTableName(m2mMapping.getRelationTableName() + "_HIST");
                    m2mMapping.setHistoryPolicy(policy);
                    continue;
                }
                if (!(mapping instanceof DirectCollectionMapping)) continue;
                DirectCollectionMapping dcMapping = (DirectCollectionMapping)mapping;
                policy = (HistoryPolicy)basePolicy.clone();
                policy.addHistoryTableName(dcMapping.getReferenceTableName() + "_HIST");
                dcMapping.setHistoryPolicy(policy);
            }
        }
    }

    public static void generateHistoryPolicies(Project project) {
        HistoryFacade.generateHistoryPolicies(project.getDescriptors().values().iterator(), (DatasourcePlatform)project.getDatasourceLogin().getPlatform());
    }

    public static void generateHistoryPolicies(Session session) {
        HistoryFacade.generateHistoryPolicies(session.getDescriptors().values().iterator(), (DatasourcePlatform)session.getPlatform());
    }
}

