/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.corba.annotation.processing;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.glassfish.corba.annotation.processing.FileGenerator;
import org.glassfish.pfl.basic.logex.ExceptionWrapper;
import org.glassfish.pfl.basic.logex.Message;

@SupportedAnnotationTypes(value={"org.glassfish.pfl.basic.logex.ExceptionWrapper", "org.glassfish.pfl.basic.logex.Message"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ExceptionWrapperProcessor
extends AbstractProcessor {
    Map<Element, FileGenerator> annotatedClasses = new HashMap<Element, FileGenerator>();
    Date creationDate = new Date();

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            return false;
        }
        if (typeElements.isEmpty()) {
            return false;
        }
        this.processClassElements(roundEnvironment.getElementsAnnotatedWith(ExceptionWrapper.class));
        this.processMethodElements(roundEnvironment.getElementsAnnotatedWith(Message.class));
        for (FileGenerator generator : this.annotatedClasses.values()) {
            this.writeFile(generator);
        }
        return true;
    }

    private void writeFile(FileGenerator generator) {
        try {
            if (generator.shouldWriteFile()) {
                generator.writeFile(this.processingEnv.getFiler());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processClassElements(Set<? extends Element> classElements) {
        for (Element element : classElements) {
            this.annotatedClasses.put(element, new FileGenerator(element, this.creationDate));
        }
    }

    private void processMethodElements(Set<? extends Element> methodElements) {
        for (Element element : methodElements) {
            if (!this.annotatedClasses.containsKey(element.getEnclosingElement())) continue;
            this.annotatedClasses.get(element.getEnclosingElement()).addMethod(element);
        }
    }
}

