/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.io.Serializable;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.Builder;
import org.eclipse.persistence.testing.models.aggregate.House;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;

public class AggregateCollectionOuterJoinTest
extends AutoVerifyTestCase {
    Class<?> cls;
    protected List objects = null;

    public AggregateCollectionOuterJoinTest(Class<?> cls) {
        this.cls = cls;
        this.setName(this.getName() + AgentBuilderHelper.getNameInBrackets(cls));
        this.setDescription("Tests that outer joins work with aggregate collections.");
    }

    public void setup() {
        Serializable frank;
        Serializable bob;
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
        if (Agent.class.equals(this.cls)) {
            bob = new Agent();
            frank = new Agent();
        } else {
            bob = new Builder();
            frank = new Builder();
        }
        AgentBuilderHelper.setFirstName(bob, "Bob");
        AgentBuilderHelper.setLastName(bob, "Smith");
        AgentBuilderHelper.setFirstName(frank, "Frank");
        AgentBuilderHelper.setLastName(frank, "Jones");
        House house = new House();
        house.setLocation("50 O'Connor St.");
        AgentBuilderHelper.addHouse(frank, house);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)bob);
        uow.registerObject((Object)frank);
        uow.commit();
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery(this.cls);
        ExpressionBuilder object = new ExpressionBuilder();
        Expression exp = object.get("firstName").equal((Object)"Bob");
        exp = exp.or(object.anyOfAllowingNone("houses").get("location").equal((Object)"435 Carling Ave."));
        query.setSelectionCriteria(exp);
        this.objects = (List)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.objects.size() != 2) {
            throw new TestErrorException("Outer join is not working correctly with AggregateCollections.");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

