/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class DeleteWithGarbageCollectionTest
extends TestCase {
    protected CacheIdentityMap cacheIdentityMap;
    protected Vector primaryKeys;
    protected int factor = 2;

    public DeleteWithGarbageCollectionTest(CacheIdentityMap cacheIdentityMap) {
        this.setCacheIdentityMap(cacheIdentityMap);
        this.setName("Tests deletion of objects which may have already been garbage collected");
    }

    public void setup() {
        this.setPrimaryKeys(new Vector(this.cacheIdentityMap.getMaxSize() * this.factor));
    }

    public void test() {
        int size = this.getCacheIdentityMap().getMaxSize() * this.factor;
        for (int i = 0; i < size; ++i) {
            BigDecimal id = new BigDecimal(i);
            Employee employee = new Employee();
            Vector<BigDecimal> pk = new Vector<BigDecimal>(1);
            employee.setId(id);
            employee.setFirstName("Joe");
            employee.setLastName("Blow");
            pk.add(id);
            this.getPrimaryKeys().add(pk);
            this.getCacheIdentityMap().put((Object)this.primaryKeys, (Object)employee, null, 0L);
        }
    }

    public void verify() {
        Vector pk2 = null;
        for (Vector pk2 : this.getPrimaryKeys()) {
            this.getCacheIdentityMap().remove((Object)pk2, null);
        }
    }

    public void reset() {
        this.setPrimaryKeys(null);
        this.factor = 2;
    }

    public CacheIdentityMap getCacheIdentityMap() {
        return this.cacheIdentityMap;
    }

    public void setCacheIdentityMap(CacheIdentityMap cacheIdentityMap) {
        this.cacheIdentityMap = cacheIdentityMap;
    }

    public Vector getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(Vector primaryKeys) {
        this.primaryKeys = primaryKeys;
    }
}

