/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.LockInObject;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampInObject;

public class TimestampNewObjectInCache
extends TestCase {
    protected Object objectToBeRead;
    protected Object lockingObject;
    public boolean isTio;

    public TimestampNewObjectInCache(Object o) {
        this.setName("TimestampNewObjectInCache(" + o.getClass().getName() + ")");
        this.lockingObject = o;
        this.setDescription("This tests whether a new object that uses Timestamp or Version locking is added to Cache.");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ExpressionBuilder bldr = new ExpressionBuilder();
        ReadObjectQuery queryObject = new ReadObjectQuery();
        queryObject.checkCacheOnly();
        if (this.lockingObject instanceof TimestampInObject) {
            this.isTio = true;
            TimestampInObject tio = (TimestampInObject)this.lockingObject;
            uow.registerObject((Object)tio);
            uow.commit();
            Expression exp = bldr.get("id").equal(tio.id);
            queryObject.setSelectionCriteria(exp);
            queryObject.setReferenceClass(TimestampInObject.class);
            this.objectToBeRead = this.getSession().executeQuery((DatabaseQuery)queryObject);
        } else if (this.lockingObject instanceof LockInObject) {
            this.isTio = false;
            LockInObject ov = (LockInObject)this.lockingObject;
            uow.registerObject((Object)ov);
            uow.commit();
            Expression exp = bldr.get("id").equal(ov.id);
            queryObject.setSelectionCriteria(exp);
            queryObject.setReferenceClass(LockInObject.class);
            this.objectToBeRead = this.getSession().executeQuery((DatabaseQuery)queryObject);
        }
    }

    public void verify() {
        if (this.objectToBeRead != this.lockingObject) {
            if (this.isTio) {
                throw new TestErrorException("New Objects using Timestamp locking are not put in Cache.");
            }
            throw new TestErrorException("New Objects using Version locking are not put in Cache.");
        }
    }
}

