/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ProjectXMLStoredProcedureCallTest
extends TestCase {
    private DatabaseQuery query;
    private DatabaseQuery UNamedQuery = null;
    private StoredProcedureCall storedProcedureCall;
    private StoredProcedureCall UNamedstoredProcedureCall = null;
    private ClassDescriptor employeeDescriptor;

    public ProjectXMLStoredProcedureCallTest() {
        this.setDescription("Tests that sepecified stored procedure can read from XML and execute correctly.");
    }

    public void reset() {
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test can only be run in Oracle");
        }
    }

    public void test() {
        Project project = XMLProjectReader.read((String)"MWIntegrationCustomSQLEmployeeProject.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.employeeDescriptor = project.getDescriptor(Employee.class);
        this.testNamedArgumentStoredProcedureCall();
        this.testUNamedArgumentStoredProcedureCall();
    }

    private void testNamedArgumentStoredProcedureCall() {
        this.query = this.employeeDescriptor.getQueryManager().getQuery("StoredProcedureCallInDataReadQuery");
        this.storedProcedureCall = (StoredProcedureCall)this.query.getCall();
    }

    private void testUNamedArgumentStoredProcedureCall() {
        this.UNamedQuery = this.employeeDescriptor.getQueryManager().getQuery("UNamedStoredProcedureCallInDataReadQuery");
        this.UNamedstoredProcedureCall = (StoredProcedureCall)this.UNamedQuery.getCall();
    }

    protected void verify() {
        this.verifyNamedArgumentStoredProcedureCall();
        this.verifyUNamedArgumentStoredProcedureCall();
    }

    private void verifyNamedArgumentStoredProcedureCall() {
        if (this.query == null) {
            throw new TestErrorException("The query was incorrectly either read from or write to XML. Expected: [StoredProcedureCallInDataReadQuery]");
        }
        if (this.storedProcedureCall == null) {
            throw new TestErrorException("The stored procedure was incorrectly either read from or write to XML.");
        }
        Vector parameters = new Vector();
        DatabaseRecord row = (DatabaseRecord)((Vector)this.getSession().executeQuery(this.query, parameters)).firstElement();
        Integer P_INOUT_FIELD_NAME = (Integer)row.get("P_INOUT_FIELD_NAME");
        Integer P_OUT_FIELD_NAME = (Integer)row.get("P_OUT_FIELD_NAME");
        if (!P_INOUT_FIELD_NAME.equals(1000) || !P_OUT_FIELD_NAME.equals(100)) {
            throw new TestErrorException("Stored Procedure which write to or read from XML does not execute as expected.");
        }
    }

    private void verifyUNamedArgumentStoredProcedureCall() {
        if (this.UNamedQuery == null) {
            throw new TestErrorException("The UNamed query name was not incorrectly either read from or write to XML. Expected: [UNamedStoredProcedureCallInDataReadQuery]");
        }
        if (this.UNamedstoredProcedureCall == null) {
            throw new TestErrorException("The UNamed stored procedure was incorrectly either read from or write to XML.");
        }
        Vector parameters = new Vector();
        DatabaseRecord unamedrow = (DatabaseRecord)((Vector)this.getSession().executeQuery(this.UNamedQuery, parameters)).firstElement();
        Integer UNAMED_P_INOUT_FIELD_NAME = (Integer)unamedrow.get("P_INOUT_FIELD_NAME");
        Integer UNAMED_P_OUT_FIELD_NAME = (Integer)unamedrow.get("P_OUT_FIELD_NAME");
        if (!UNAMED_P_INOUT_FIELD_NAME.equals(1000) || !UNAMED_P_OUT_FIELD_NAME.equals(100)) {
            throw new TestErrorException("UNnamed Stored Procedure which write to or read from XML dose not execute as expected.");
        }
    }
}

