/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import oracle.kv.impl.api.table.AnyAtomicDefImpl;
import oracle.kv.impl.api.table.AnyDefImpl;
import oracle.kv.impl.api.table.AnyJsonAtomicDefImpl;
import oracle.kv.impl.api.table.AnyRecordDefImpl;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.NumberDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.table.FieldDef;

public class FieldDefFactory {
    public static IntegerDefImpl createIntegerDef() {
        return FieldDefImpl.integerDef;
    }

    public static LongDefImpl createLongDef() {
        return FieldDefImpl.longDef;
    }

    public static FloatDefImpl createFloatDef() {
        return FieldDefImpl.floatDef;
    }

    public static JsonDefImpl createJsonDef() {
        return FieldDefImpl.jsonDef;
    }

    public static DoubleDefImpl createDoubleDef() {
        return FieldDefImpl.doubleDef;
    }

    public static NumberDefImpl createNumberDef() {
        return FieldDefImpl.numberDef;
    }

    public static StringDefImpl createStringDef() {
        return FieldDefImpl.stringDef;
    }

    public static EnumDefImpl createEnumDef(String[] values) {
        return new EnumDefImpl(values, null);
    }

    public static BooleanDefImpl createBooleanDef() {
        return FieldDefImpl.booleanDef;
    }

    public static BinaryDefImpl createBinaryDef() {
        return FieldDefImpl.binaryDef;
    }

    public static FixedBinaryDefImpl createFixedBinaryDef(int size) {
        return new FixedBinaryDefImpl(size, null);
    }

    public static TimestampDefImpl createTimestampDef(int precision) {
        return FieldDefImpl.timestampDefs[precision];
    }

    public static RecordDefImpl createRecordDef(FieldMap fieldMap, String descr) {
        return new RecordDefImpl(fieldMap, descr);
    }

    public static ArrayDefImpl createArrayDef(FieldDefImpl elemType) {
        return FieldDefFactory.createArrayDef(elemType, null);
    }

    public static ArrayDefImpl createArrayDef(FieldDefImpl elemType, String descr) {
        if (descr == null) {
            if (elemType.isJson()) {
                return FieldDefImpl.arrayJsonDef;
            }
            if (elemType.isAny()) {
                return FieldDefImpl.arrayAnyDef;
            }
        }
        return new ArrayDefImpl(elemType, descr);
    }

    public static MapDefImpl createMapDef(FieldDefImpl elemType) {
        return FieldDefFactory.createMapDef(elemType, null);
    }

    public static MapDefImpl createMapDef(FieldDefImpl elemType, String descr) {
        if (descr == null) {
            if (elemType.isJson()) {
                return FieldDefImpl.mapJsonDef;
            }
            if (elemType.isAny()) {
                return FieldDefImpl.mapAnyDef;
            }
        }
        return new MapDefImpl(elemType, descr);
    }

    public static AnyDefImpl createAnyDef() {
        return FieldDefImpl.anyDef;
    }

    public static AnyAtomicDefImpl createAnyAtomicDef() {
        return FieldDefImpl.anyAtomicDef;
    }

    public static AnyJsonAtomicDefImpl createAnyJsonAtomicDef() {
        return FieldDefImpl.anyJsonAtomicDef;
    }

    public static AnyRecordDefImpl createAnyRecordDef() {
        return FieldDefImpl.anyRecordDef;
    }

    public static FieldDefImpl createAtomicTypeDef(FieldDef.Type type) {
        switch (type) {
            case STRING: {
                return FieldDefFactory.createStringDef();
            }
            case INTEGER: {
                return FieldDefFactory.createIntegerDef();
            }
            case LONG: {
                return FieldDefFactory.createLongDef();
            }
            case DOUBLE: {
                return FieldDefFactory.createDoubleDef();
            }
            case FLOAT: {
                return FieldDefFactory.createFloatDef();
            }
            case NUMBER: {
                return FieldDefFactory.createNumberDef();
            }
            case BINARY: {
                return FieldDefFactory.createBinaryDef();
            }
            case BOOLEAN: {
                return FieldDefFactory.createBooleanDef();
            }
        }
        throw new IllegalArgumentException("Cannot create an atomic field def of type " + type);
    }
}

