/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.MathContext;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.ParallelScanIterator;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.ops.TableQuery;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.ResumeInfo;
import oracle.kv.impl.query.runtime.ServerIterFactory;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.UserDataControl;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.FieldValue;

public class RuntimeControlBlock {
    private final KVStoreImpl theStore;
    private final Logger theLogger;
    private final TableMetadataHelper theMetadataHelper;
    private final Set<Integer> thePartitions;
    private final Set<RepGroupId> theShards;
    private final ExecuteOptions theExecuteOptions;
    private final byte theTraceLevel;
    private TableQuery theQueryOp;
    private final PlanIter theRootIter;
    private final ServerIterFactory theServerIterFactory;
    private final PlanIterState[] theIteratorStates;
    private final FieldValueImpl[] theRegisters;
    private final FieldValue[] theExternalVars;
    private final int theCurrentMaxReadKB;
    private byte[] theContinuationKey;
    private int thePidOrShardIdx;
    private ResumeInfo theResumeInfo;
    private final AtomicInteger theReadKB;
    private final AtomicInteger theWriteKB;
    private int theResultSize;
    private boolean theReachedLimit;
    private ParallelScanIterator<FieldValueImpl> theTableIterator;
    long theMemoryConsumption;

    public RuntimeControlBlock(KVStoreImpl store, Logger logger, TableMetadataHelper mdHelper, Set<Integer> partitions, Set<RepGroupId> shards, ExecuteOptions executeOptions, PlanIter rootIter, int numIters, int numRegs, FieldValue[] externalVars) {
        this(store, logger, mdHelper, partitions, shards, executeOptions, null, null, rootIter, numIters, numRegs, externalVars);
    }

    public RuntimeControlBlock(KVStoreImpl store, Logger logger, TableMetadataHelper mdHelper, Set<Integer> partitions, Set<RepGroupId> shards, ExecuteOptions executeOptions, TableQuery queryOp, ServerIterFactory serverIterFactory, PlanIter rootIter, int numIters, int numRegs, FieldValue[] externalVars) {
        this.theStore = store;
        this.theLogger = logger;
        this.theMetadataHelper = mdHelper;
        this.thePartitions = partitions;
        this.theShards = shards;
        this.theExecuteOptions = executeOptions;
        this.theTraceLevel = executeOptions != null ? executeOptions.getTraceLevel() : (byte)0;
        this.theQueryOp = queryOp;
        this.theRootIter = rootIter;
        this.theServerIterFactory = serverIterFactory;
        this.theIteratorStates = new PlanIterState[numIters];
        this.theRegisters = new FieldValueImpl[numRegs];
        this.theExternalVars = externalVars;
        this.theCurrentMaxReadKB = this.isServerRCB() ? this.theQueryOp.getCurrentMaxReadKB() : 0;
        this.theContinuationKey = this.theExecuteOptions != null ? this.theExecuteOptions.getContinuationKey() : null;
        this.parseContinuationKey();
        this.theReadKB = new AtomicInteger();
        this.theWriteKB = new AtomicInteger();
    }

    boolean isServerRCB() {
        return this.theStore == null;
    }

    public KVStoreImpl getStore() {
        return this.theStore;
    }

    public Logger getLogger() {
        return this.theLogger;
    }

    public TableMetadataHelper getMetadataHelper() {
        return this.theMetadataHelper;
    }

    public Set<Integer> getPartitionSet() {
        return this.thePartitions;
    }

    public Set<RepGroupId> getShardSet() {
        return this.theShards;
    }

    public ExecuteOptions getExecuteOptions() {
        return this.theExecuteOptions;
    }

    public byte getTraceLevel() {
        return this.theTraceLevel;
    }

    public void trace(String msg) {
        if (!UserDataControl.hideUserData()) {
            this.theLogger.info("QUERY:" + msg);
        }
    }

    Consistency getConsistency() {
        return this.theExecuteOptions.getConsistency();
    }

    Durability getDurability() {
        return this.theExecuteOptions.getDurability();
    }

    long getTimeout() {
        return this.theExecuteOptions.getTimeout();
    }

    TimeUnit getTimeUnit() {
        return this.theExecuteOptions.getTimeoutUnit();
    }

    public MathContext getMathContext() {
        return this.theExecuteOptions.getMathContext();
    }

    int getBatchSize() {
        return this.theExecuteOptions.getResultsBatchSize();
    }

    public boolean getUseBatchSizeAsLimit() {
        return this.theExecuteOptions.getUseBatchSizeAsLimit();
    }

    public int getMaxReadKB() {
        return this.theExecuteOptions.getMaxReadKB();
    }

    public long getMaxMemoryConsumption() {
        return this.theExecuteOptions.getMaxMemoryConsumption();
    }

    void incMemoryConsumption(long v) {
        this.theMemoryConsumption += v;
        assert (this.theMemoryConsumption >= 0L);
        if (this.theMemoryConsumption > this.getMaxMemoryConsumption()) {
            throw new QueryStateException("Memory consumption at the client exceeded maximum allowed value " + this.getMaxMemoryConsumption());
        }
    }

    void decMemoryConsumption(long v) {
        this.theMemoryConsumption -= v;
        assert (this.theMemoryConsumption >= 0L);
    }

    public LogContext getLogContext() {
        return this.theExecuteOptions.getLogContext();
    }

    public TableQuery getQueryOp() {
        return this.theQueryOp;
    }

    public ResumeInfo getResumeInfo() {
        if (this.isServerRCB()) {
            if (this.theQueryOp == null) {
                return null;
            }
            return this.theQueryOp.getResumeInfo();
        }
        return this.theResumeInfo;
    }

    public ServerIterFactory getServerIterFactory() {
        return this.theServerIterFactory;
    }

    PlanIter getRootIter() {
        return this.theRootIter;
    }

    public void setState(int pos, PlanIterState state) {
        this.theIteratorStates[pos] = state;
    }

    public PlanIterState getState(int pos) {
        return this.theIteratorStates[pos];
    }

    public FieldValueImpl[] getRegisters() {
        return this.theRegisters;
    }

    public FieldValueImpl getRegVal(int regId) {
        return this.theRegisters[regId];
    }

    public void setRegVal(int regId, FieldValueImpl value) {
        this.theRegisters[regId] = value;
    }

    FieldValue[] getExternalVars() {
        return this.theExternalVars;
    }

    FieldValueImpl getExternalVar(int id) {
        if (this.theExternalVars == null) {
            return null;
        }
        return (FieldValueImpl)this.theExternalVars[id];
    }

    public int getCurrentMaxReadKB() {
        return this.theCurrentMaxReadKB;
    }

    public byte[] getContinuationKey() {
        return this.theContinuationKey;
    }

    void setContinuationKey(byte[] key) {
        this.theContinuationKey = key;
    }

    public void tallyReadKB(int nkb) {
        this.theReadKB.addAndGet(nkb);
    }

    public void tallyWriteKB(int nkb) {
        this.theWriteKB.addAndGet(nkb);
    }

    public int getReadKB() {
        return this.theReadKB.get();
    }

    public int getWriteKB() {
        return this.theWriteKB.get();
    }

    public void tallyResultSize(int size) {
        this.theResultSize += size;
    }

    public int getResultSize() {
        return this.theResultSize;
    }

    public void setReachedLimit(boolean value) {
        this.theReachedLimit = value;
    }

    public boolean getReachedLimit() {
        return this.theReachedLimit;
    }

    int getPidIdx() {
        return this.thePidOrShardIdx;
    }

    int incPidIdx() {
        return ++this.thePidOrShardIdx;
    }

    int getShardIdx() {
        return this.thePidOrShardIdx;
    }

    int incShardIdx() {
        return ++this.thePidOrShardIdx;
    }

    private void parseContinuationKey() {
        if (this.theContinuationKey == null) {
            this.theResumeInfo = new ResumeInfo(this);
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.theContinuationKey);
        DataInputStream in = new DataInputStream(bais);
        short v = SerialVersion.CURRENT;
        try {
            this.thePidOrShardIdx = in.readInt();
            this.theResumeInfo = new ResumeInfo(in, v);
            this.theResumeInfo.setRCB(this);
        }
        catch (IOException e) {
            throw new QueryStateException("Failed to parse continuation key");
        }
    }

    void createContinuationKey() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        short v = SerialVersion.CURRENT;
        try {
            out.writeInt(this.thePidOrShardIdx);
            this.theResumeInfo.writeFastExternal(out, v);
        }
        catch (IOException e) {
            throw new QueryStateException("Failed to create continuation key. Reason:\n" + e.getMessage());
        }
        this.theContinuationKey = baos.toByteArray();
        this.theReachedLimit = true;
    }

    void setTableIterator(ParallelScanIterator<FieldValueImpl> iter) {
        this.theTableIterator = iter;
    }

    public ParallelScanIterator<FieldValueImpl> getTableIterator() {
        return this.theTableIterator;
    }
}

