/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointConfigBuilder;
import oracle.kv.impl.security.ssl.SSLConfig;
import oracle.kv.impl.util.CommonLoggerUtils;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.registry.ClearSocketPolicy;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.TimeoutSocket;

public class ClientSocketFactory
implements FastExternalizable,
RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile Logger logger = null;
    private static final List<TimeoutSocket> sockets = new LinkedList<TimeoutSocket>();
    private static final Timer timer = new Timer("KVClientSocketTimeout", true);
    static volatile TimeoutTask timeoutTask = new TimeoutTask();
    protected volatile transient AtomicInteger socketCount = new AtomicInteger(0);
    protected static final AtomicInteger socketFactoryCount = new AtomicInteger(0);
    private static final Map<String, SocketTimeouts> storeToTimeoutsMap = new ConcurrentHashMap<String, SocketTimeouts>();
    private static final AtomicInteger currCsfGeneration = new AtomicInteger(0);
    private static final AtomicLong nextCsfId = new AtomicLong(System.nanoTime());
    private static RMISocketPolicy clientPolicy;
    private static SSLConfig sslConfig;
    protected final String name;
    protected volatile int connectTimeoutMs;
    protected volatile int readTimeoutMs;
    private volatile transient int csfGeneration;
    private final long csfId;

    public static void newGeneration() {
        currCsfGeneration.incrementAndGet();
    }

    public ClientSocketFactory(String name, int connectTimeoutMs, int readTimeoutMs) {
        this.name = name;
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.csfGeneration = currCsfGeneration.get();
        this.csfId = nextCsfId.getAndIncrement();
    }

    protected ClientSocketFactory(DataInput in, short serialVersion) throws IOException {
        this.name = SerializationUtil.readString(in, serialVersion);
        this.connectTimeoutMs = SerializationUtil.readPackedInt(in);
        this.readTimeoutMs = SerializationUtil.readPackedInt(in);
        this.csfId = SerializationUtil.readPackedLong(in);
        this.updateAfterDeserialization();
    }

    static List<TimeoutSocket> getSockets() {
        return sockets;
    }

    public static String factoryName(String kvsName, String compName, String interfaceName) {
        return kvsName + '|' + compName + '|' + interfaceName;
    }

    public static String registryFactoryName() {
        return "registry";
    }

    public String getBindingName() {
        return this.name;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public int getSocketCount() {
        return this.socketCount.get();
    }

    public static int getSocketFactoryCount() {
        return socketFactoryCount.get();
    }

    public static void setSocketFactoryCount(int count) {
        socketFactoryCount.set(count);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.connectTimeoutMs;
        result = 31 * result + this.readTimeoutMs;
        result = 31 * result + (int)this.csfId;
        result = 31 * result + this.csfGeneration;
        return result;
    }

    public String toString() {
        return "<ClientSocketFactory name=" + this.name + " id=" + this.hashCode() + " connectMs=" + this.connectTimeoutMs + " readMs=" + this.readTimeoutMs + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientSocketFactory other = (ClientSocketFactory)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.connectTimeoutMs != other.connectTimeoutMs) {
            return false;
        }
        if (this.readTimeoutMs != other.readTimeoutMs) {
            return false;
        }
        if (this.csfGeneration != other.csfGeneration) {
            return false;
        }
        return this.csfId == other.csfId;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.updateAfterDeserialization();
    }

    private void updateAfterDeserialization() {
        this.csfGeneration = currCsfGeneration.get();
        if (this.name == null) {
            return;
        }
        SocketTimeouts timeouts = storeToTimeoutsMap.get(this.name);
        if (timeouts != null) {
            this.connectTimeoutMs = timeouts.connectTimeoutMs;
            this.readTimeoutMs = timeouts.readTimeoutMs;
        }
        this.socketCount = new AtomicInteger();
        socketFactoryCount.incrementAndGet();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeString(out, serialVersion, this.name);
        SerializationUtil.writePackedInt(out, this.connectTimeoutMs);
        SerializationUtil.writePackedInt(out, this.readTimeoutMs);
        SerializationUtil.writePackedLong(out, this.csfId);
    }

    @Override
    public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        return this.createTimeoutSocket(host, port);
    }

    protected TimeoutSocket createTimeoutSocket(String host, int port) throws UnknownHostException, IOException {
        TimeoutSocket sock = new TimeoutSocket(this.readTimeoutMs);
        sock.connect(new InetSocketAddress(host, port), this.connectTimeoutMs);
        sock.setTcpNoDelay(true);
        this.socketCount.incrementAndGet();
        timeoutTask.register(sock);
        return sock;
    }

    public static void configureStoreTimeout(String bindingName, int connectTimeoutMs, int readTimeoutMs) {
        storeToTimeoutsMap.put(bindingName, new SocketTimeouts(connectTimeoutMs, readTimeoutMs));
    }

    public static void clearStoreTimeouts() {
        storeToTimeoutsMap.clear();
    }

    public static void setTimeoutLogger(Logger logger) {
        ClientSocketFactory.logger = logger;
    }

    public static void setRMIPolicy(Properties securityProps) {
        ClientSocketFactory.setRMIPolicy(securityProps, null);
    }

    public static synchronized void setRMIPolicy(Properties securityProps, String storeName) {
        String transportName;
        String string = transportName = securityProps == null ? null : securityProps.getProperty("oracle.kv.transport");
        if ("internal".equals(transportName)) {
            return;
        }
        sslConfig = null;
        if ("ssl".equals(transportName)) {
            sslConfig = new SSLConfig(securityProps);
            clientPolicy = sslConfig.makeClientSocketPolicy();
        } else if (transportName == null || "clear".equals(transportName)) {
            clientPolicy = new ClearSocketPolicy();
        } else {
            throw new IllegalArgumentException("Transport " + transportName + " is not supported.");
        }
        clientPolicy.prepareClient(storeName);
    }

    public static synchronized void setRMIPolicy(RMISocketPolicy policy) {
        clientPolicy = policy;
        clientPolicy.prepareClient(null);
    }

    private static synchronized RMISocketPolicy getRMIPolicy() {
        return clientPolicy;
    }

    public static synchronized RMISocketPolicy ensureRMISocketPolicy() {
        RMISocketPolicy policy = ClientSocketFactory.getRMIPolicy();
        if (policy == null) {
            ClientSocketFactory.setRMIPolicy(new ClearSocketPolicy());
        }
        return clientPolicy;
    }

    public static synchronized RMISocketPolicy resetRMISocketPolicy(String storeName) {
        if (sslConfig != null) {
            clientPolicy = sslConfig.makeClientSocketPolicy();
            clientPolicy.prepareClient(storeName);
        }
        return clientPolicy;
    }

    public final EndpointConfig getEndpointConfig() throws IOException {
        return this.getEndpointConfigBuilder().build();
    }

    public EndpointConfigBuilder getEndpointConfigBuilder() throws IOException {
        return new EndpointConfigBuilder().option(AsyncOption.DLG_CONNECT_TIMEOUT, this.connectTimeoutMs).option(AsyncOption.DLG_HEARTBEAT_TIMEOUT, this.readTimeoutMs);
    }

    public static void changeTimerInterval(long intervalMs) {
        if (timeoutTask != null) {
            timeoutTask.cancel();
        }
        timeoutTask = intervalMs != 0L ? new TimeoutTask(intervalMs) : new TimeoutTask();
    }

    private static class TimeoutTask
    extends TimerTask {
        private static final long DEFAULT_TIMER_INTERVAL_MS = 1000L;
        private final long intervalMs;
        private long elapsedMs = 0L;

        TimeoutTask() {
            this(1000L);
        }

        TimeoutTask(long intervalMs) {
            this.intervalMs = intervalMs;
            timer.schedule((TimerTask)this, intervalMs, intervalMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.elapsedMs += this.intervalMs;
            try {
                List list = sockets;
                synchronized (list) {
                    Iterator i = sockets.iterator();
                    while (i.hasNext()) {
                        if (((TimeoutSocket)i.next()).isActive(this.elapsedMs, logger)) continue;
                        i.remove();
                    }
                }
            }
            catch (Throwable t) {
                String message = "ClientSocketFactory.TimerTask: " + CommonLoggerUtils.getStackTrace(t);
                if (logger == null) {
                    System.err.println(message);
                }
                logger.severe(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(TimeoutSocket socket) {
            if (logger != null && logger.isLoggable(Level.FINE)) {
                logger.fine("Registering " + socket + " onto timeout monitoring list. " + sockets.size() + " sockets currently registered");
            }
            List list = sockets;
            synchronized (list) {
                sockets.add(socket);
            }
        }
    }

    private static class SocketTimeouts {
        private final int connectTimeoutMs;
        private final int readTimeoutMs;

        SocketTimeouts(int connectTimeoutMs, int readTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            this.readTimeoutMs = readTimeoutMs;
        }
    }
}

