/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.insurance.Address;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class DescriptorIsMissingTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public DescriptorIsMissingTest() {
        this.setDescription("This tests Parent Descriptor Not Specified (TL-ERROR 110) ");
    }

    protected void setup() {
        this.expectedException = DescriptorException.descriptorIsMissing(null, null);
        this.orgDescriptor = this.getSession().getDescriptor(Address.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        this.getSession().getDescriptors().remove(Address.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.buildAddressDescriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        descriptor.addTableName("INS_ADDR");
        descriptor.addPrimaryKeyFieldName("INS_ADDR.SSN");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        OneToOneMapping policyHolderMapping = new OneToOneMapping();
        policyHolderMapping.setAttributeName("policyHolder");
        policyHolderMapping.setGetMethodName("getPolicyHolder");
        policyHolderMapping.setSetMethodName("setPolicyHolder");
        policyHolderMapping.setReferenceClass(PolicyHolder.class);
        policyHolderMapping.dontUseIndirection();
        policyHolderMapping.addForeignKeyFieldName("INS_ADDR.SSN", "HOLDER.SSN");
        descriptor.addMapping((DatabaseMapping)policyHolderMapping);
        return descriptor;
    }
}

