/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.sdk;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.ConnectionMetaData;
import jakarta.resource.cci.Interaction;
import jakarta.resource.cci.LocalTransaction;
import jakarta.resource.cci.ResultSetInfo;
import oracle.nosql.driver.NoSQLHandle;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLConnectionMetaData;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLInteraction;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLJCAConnectionSpec;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLTransaction;

public class OracleNoSQLConnection
implements Connection {
    private OracleNoSQLJCAConnectionSpec spec;
    private OracleNoSQLTransaction transaction;
    private NoSQLHandle noSQLHandle = null;

    public OracleNoSQLConnection(NoSQLHandle noSQLHandle, OracleNoSQLJCAConnectionSpec spec) {
        this.noSQLHandle = noSQLHandle;
        this.transaction = new OracleNoSQLTransaction(this);
        this.spec = spec;
    }

    public void close() throws ResourceException {
        try {
            this.noSQLHandle.close();
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(exception.toString());
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
    }

    public Interaction createInteraction() {
        return new OracleNoSQLInteraction(this);
    }

    public OracleNoSQLJCAConnectionSpec getConnectionSpec() {
        return this.spec;
    }

    public LocalTransaction getLocalTransaction() {
        return this.transaction;
    }

    public OracleNoSQLTransaction getOracleNoSQLTransaction() {
        return this.transaction;
    }

    public ConnectionMetaData getMetaData() {
        return new OracleNoSQLConnectionMetaData(this);
    }

    public ResultSetInfo getResultSetInfo() {
        throw ValidationException.operationNotSupported((String)"getResultSetInfo");
    }

    public NoSQLHandle getNoSQLHandle() {
        return this.noSQLHandle;
    }
}

