/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.plsql;

import java.util.List;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestCase;

public class PLSQLTest
extends TestCase {
    protected String queryName;
    protected Class<?> queryClass;
    protected List queryArguments;
    protected Object result;

    public PLSQLTest() {
    }

    public PLSQLTest(String queryName, Class<?> queryClass, List queryArguments) {
        this.queryName = queryName;
        this.queryClass = queryClass;
        this.queryArguments = queryArguments;
    }

    public PLSQLTest(String queryName, Class<?> queryClass, List queryArguments, Object result) {
        this.queryName = queryName;
        this.queryClass = queryClass;
        this.queryArguments = queryArguments;
        this.result = result;
    }

    public void test() {
        Object queryResult = null;
        try {
            queryResult = this.getSession().executeQuery(this.queryName, this.queryClass, this.queryArguments);
        }
        catch (RuntimeException exception) {
            if (this.result instanceof EclipseLinkException && exception.getClass() == this.result.getClass() && ((EclipseLinkException)((Object)exception)).getErrorCode() == ((EclipseLinkException)((Object)this.result)).getErrorCode()) {
                return;
            }
            throw exception;
        }
        if (this.result == null) {
            return;
        }
        if (this.result.getClass() != queryResult.getClass()) {
            if (queryResult instanceof List) {
                queryResult = ((List)queryResult).get(0);
            }
            if (this.result.getClass() != queryResult.getClass()) {
                this.throwError("Results do not match: " + queryResult + " expected: " + this.result);
            }
        }
        if (this.result instanceof DatabaseRecord) {
            DatabaseRecord record = (DatabaseRecord)this.result;
            DatabaseRecord queryRecord = (DatabaseRecord)queryResult;
            for (DatabaseField field : record.getFields()) {
                Object value = record.get(field);
                Object queryValue = queryRecord.get(field);
                if (value instanceof Number) {
                    value = value.toString();
                    queryValue = queryValue.toString();
                }
                if (value.equals(queryValue)) continue;
                this.throwError("Results do not match: " + queryValue + " expected: " + value);
            }
        }
    }
}

