/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.MultiNameQueriesTestCase;

public class NamedQueryGetQueryNoArgumentsTest
extends MultiNameQueriesTestCase {
    protected Exception caughtException;
    protected ClassDescriptor descriptor;

    public NamedQueryGetQueryNoArgumentsTest() {
        this.setDescription("Verifies if a Named Query with no arguments can be retreived from DescriptorQueryManager just by calling getQuery, eventhough there are some other queries with the same name cached on DescriptorQueryManager");
    }

    public void reset() {
        this.descriptor.getQueryManager().removeQuery("namedQuerySameName");
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.setDescriptorNamedQueries(Employee.class);
        this.addNamedQueryFirstName();
        this.addNamedQueryFirstAndLastName();
        this.addNamedQueryFirstAndLastNameNoArguments();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public ClassDescriptor getDescriptorNamedQueries() {
        return this.descriptor;
    }

    public void setDescriptorNamedQueries(Class<?> cls) {
        this.descriptor = this.getSession().getClassDescriptor(cls);
    }

    public void useNamedQueryFirstAndLastNameNoArguments() {
        ReadAllQuery queryFirstAndLastNameNoArguments = (ReadAllQuery)this.descriptor.getQueryManager().getQuery("namedQuerySameName");
        Vector empsByFirstAndLastNameNoArguments = (Vector)this.getSession().executeQuery((DatabaseQuery)queryFirstAndLastNameNoArguments);
    }

    public void addNamedQueryFirstName() {
        this.descriptor.getQueryManager().addQuery("namedQuerySameName", (DatabaseQuery)this.getNamedQueryFirstName());
    }

    public void addNamedQueryFirstAndLastName() {
        this.descriptor.getQueryManager().addQuery("namedQuerySameName", (DatabaseQuery)this.getNamedQueryFirstAndLastName());
    }

    public void addNamedQueryFirstAndLastNameNoArguments() {
        this.descriptor.getQueryManager().addQuery("namedQuerySameName", (DatabaseQuery)this.getNamedQueryFirstAndLastNameNoArguments());
    }

    public void test() {
        try {
            this.useNamedQueryFirstAndLastNameNoArguments();
        }
        catch (ClassCastException e) {
            this.caughtException = e;
        }
    }

    public void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("Multiple queries with the same named cached on the DescriptorQueryManager.\nEach with different argument sets, or no arguments.\nThis exception thrown while testing test case\n----- NamedQueryGetQueryNoArgumentsTest() -----\n");
        }
    }
}

