/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PessimisticLockFineGrainedTest
extends TestCase {
    public UnitOfWork uow;
    public short lockMode;
    CMPPolicy oldCMPPolicy;

    public PessimisticLockFineGrainedTest(short lockMode) {
        this.lockMode = lockMode;
        this.setName(this.getName() + "(mode=" + lockMode + ")");
        this.setDescription("This test verifies the pessimistic locking feature works properly when set on the descriptor.");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ClassDescriptor addressDescriptor = this.getSession().getDescriptor(Address.class);
        CMPPolicy cmpPolicy = new CMPPolicy();
        PessimisticLockingPolicy policy = new PessimisticLockingPolicy();
        policy.setLockingMode(this.lockMode);
        cmpPolicy.setPessimisticLockingPolicy(policy);
        this.oldCMPPolicy = addressDescriptor.getCMPPolicy();
        addressDescriptor.setCMPPolicy(cmpPolicy);
        addressDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery()).setLockMode((short)-1);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.uow != null) {
            this.uow.release();
        }
        ClassDescriptor addressDescriptor = this.getSession().getDescriptor(Address.class);
        addressDescriptor.setCMPPolicy(this.oldCMPPolicy);
        addressDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery()).setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery()).dontRefreshIdentityMapResult();
    }

    public void test() throws Exception {
        this.checkSelectForUpateSupported();
        if (this.lockMode == 2) {
            this.checkNoWaitSupported();
        }
        this.uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        Expression expression = query.getExpressionBuilder().get("address").get("city").equal((Object)"Ottawa");
        query.setSelectionCriteria(expression);
        query.addJoinedAttribute("address");
        Object result = this.uow.executeQuery((DatabaseQuery)query);
        result.toString();
        DatabaseSession session2 = null;
        UnitOfWork uow2 = null;
        try {
            session2 = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession().getProject().createDatabaseSession() : this.getSession().getProject().createDatabaseSession();
            session2.setLog(this.getSession().getLog());
            session2.setLogLevel(this.getSession().getLogLevel());
            session2.login();
            uow2 = session2.acquireUnitOfWork();
            boolean isLocked = false;
            query = new ReadObjectQuery(Employee.class);
            expression = query.getExpressionBuilder().get("address").get("city").equal((Object)"Ottawa");
            query.setSelectionCriteria(expression);
            Employee result2 = (Employee)uow2.executeQuery((DatabaseQuery)query);
            try {
                result2.getAddress();
            }
            catch (EclipseLinkException exeception) {
                session2.logMessage(exeception.toString());
                isLocked = true;
            }
            if (result2 == null) {
                isLocked = true;
            }
            if (!isLocked) {
                throw new TestErrorException("Select for update does not acquire a lock");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (uow2 != null) {
                uow2.release();
            }
            if (session2 != null) {
                session2.logout();
            }
        }
    }
}

