/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.inheritance.Computer;
import org.eclipse.persistence.testing.models.inheritance.InheritanceSystem;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;
import org.eclipse.persistence.testing.tests.returning.ProjectAndDatabaseAdapter;

public class TestSystemAdapted
extends TestSystem {
    protected ProjectAndDatabaseAdapter adapter;
    protected TestSystem testSystem;

    public TestSystemAdapted() {
    }

    public TestSystemAdapted(TestSystem testSystemToBeAdapted, ProjectAndDatabaseAdapter adapter) {
        this();
        this.setAdapter(adapter);
        this.setTestSystem(testSystemToBeAdapted);
    }

    public void setAdapter(ProjectAndDatabaseAdapter adapter) {
        this.adapter = adapter;
    }

    public ProjectAndDatabaseAdapter getAdapter() {
        return this.adapter;
    }

    public void setTestSystem(TestSystem testSystemToBeAdapted) {
        this.testSystem = testSystemToBeAdapted;
    }

    public TestSystem getTestSystem() {
        return this.testSystem;
    }

    public void addDescriptors(DatabaseSession session) {
        if (this.project == null) {
            if (this.getAdapter().isOriginalSetupRequired()) {
                try {
                    TestSystem tempTestSystem = (TestSystem)this.getTestSystem().getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    tempTestSystem.addDescriptors(session);
                    try {
                        tempTestSystem.createTables(session);
                    }
                    catch (Exception ex2) {
                        throw new TestProblemException("Exception thrown by " + Helper.getShortClassName((Object)tempTestSystem) + ".createTables() ", (Throwable)ex2);
                    }
                }
                catch (Exception ex1) {
                    throw new TestProblemException("Failed to create an instance of " + this.getTestSystem().getClass() + " ", (Throwable)ex1);
                }
            }
            DatabaseSession dummyDatabaseSession = new Project((Login)session.getLogin().clone()).createDatabaseSession();
            this.getTestSystem().addDescriptors(dummyDatabaseSession);
            this.project = dummyDatabaseSession.getProject();
            this.getAdapter().updateProject(this.project, (Session)session);
        }
        session.addDescriptors(this.project);
        TestSystemAdapted.afterAddDescriptors((Session)session, this.getTestSystem());
    }

    public void createTables(DatabaseSession session) throws Exception {
        this.getTestSystem().createTables(session);
        this.getAdapter().updateDatabase((Session)session);
    }

    public String toString() {
        return Helper.getShortClassName((Object)this.getTestSystem()) + " using " + Helper.getShortClassName((Object)this.getAdapter());
    }

    public void populate(DatabaseSession session) throws Exception {
        this.getTestSystem().populate(session);
    }

    protected static void afterAddDescriptors(Session session, TestSystem aTestSystem) {
        DatabasePlatform platform;
        if (aTestSystem instanceof InheritanceSystem && ((platform = session.getLogin().getPlatform()).isOracle() || platform.isSybase() || platform.isSQLAnywhere())) {
            ClassDescriptor computerDescriptor = session.getClassDescriptor(Computer.class);
            ClassDescriptor vehicleDescriptor = session.getClassDescriptor(Vehicle.class);
            if (computerDescriptor.getInheritancePolicy().requiresMultipleTableSubclassRead()) {
                computerDescriptor.getInheritancePolicy().setReadAllSubclassesViewName("AllComputers");
            }
            if (vehicleDescriptor.getInheritancePolicy().requiresMultipleTableSubclassRead()) {
                vehicleDescriptor.getInheritancePolicy().setReadAllSubclassesViewName("AllVehicles");
            }
        }
    }
}

