/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.IdentityHashMap;
import org.eclipse.persistence.internal.helper.IdentityHashSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UOWPrimaryKeyToNewObjectsDuplicateObjectsTest
extends TestCase {
    public UOWPrimaryKeyToNewObjectsDuplicateObjectsTest() {
        this.setDescription("This test verifies that no duplicates exist in primaryKeyToNewObjects after registering a new object");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        Session session = this.getSession();
        UnitOfWorkImpl uow = (UnitOfWorkImpl)session.acquireUnitOfWork();
        Employee emp = new Employee();
        emp.setFirstName("UOWPrimaryKeyToNewObjectsDuplicateObjectsTest");
        uow.registerNewObjectForPersist((Object)emp, new IdentityHashMap());
        UOWPrimaryKeyToNewObjectsDuplicateObjectsTest.assertEquals((String)"Unexpected amount of entities in primaryKeyToNewObjects", (int)1, (int)((IdentityHashSet)uow.getPrimaryKeyToNewObjects().get(emp.getId())).size());
    }
}

