/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.LoadBuildSystem;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.tests.TestRunModel;

public class PromptTestRunner {
    public static final String DB_DRIVER_KEY = "db.driver";
    public static final String DB_DRIVER_DEFAULT = "oracle.jdbc.OracleDriver";
    public static final String DB_URL_KEY = "db.url";
    public static final String DB_URL_DEFAULT = "jdbc:oracle:thin:@localhost:1521:ORCL";
    public static final String DB_USER_KEY = "db.user";
    public static final String DB_USER_DEFAULT = "scott";
    public static final String DB_PWD_KEY = "db.pwd";
    public static final String DB_PWD_DEFAULT = "tiger";
    public static final String DB_PLATFORM_KEY = "db.platform";
    public static final String DB_PLATFORM_DEFAULT = "org.eclipse.persistence.platform.database.OraclePlatform";
    public static final String LOGGING_LEVEL_KEY = "eclipselink.logging.level";
    public static final String LOGGING_LEVEL_DEFAULT = "info";
    protected static final String TEST_MODEL_FLAG = "testmodel=";
    protected static final String TEST_ENTITY_FLAG = "testentity=";
    protected static final String REGRESSION_LOG_FLAG = "regressionlog=";
    protected static final String USE_NATIVE_SQL_FLAG = "usenativesql=";
    protected static final String SAVE_RESULTS_FLAG = "saveresults=";
    protected static final String CREATE_DB_CONNECTION_FLAG = "createdbconnection=";
    private String databasePlatform;
    private String driverClass;
    private String databaseURL;
    private String username;
    private String password;
    private Writer regressionLog;
    private boolean shouldHandleErrors = true;
    private boolean useNativeSQL = false;
    private boolean saveResults = false;
    private boolean createDbConnection = true;
    private TestModel testModel;
    private TestEntity testEntity;
    private DatabaseSession session;
    private int sessionLogLevel;

    public static void log(String str) {
        System.out.println(str);
    }

    public void login() {
        this.getLoginProperties();
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((DatabasePlatform)Class.forName(this.databasePlatform).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printUsageAndExit();
        }
        login.setDriverClassName(this.driverClass);
        login.setConnectionString(this.databaseURL);
        login.setUserName(this.username);
        login.setEncryptedPassword(this.password);
        if (this.useNativeSQL) {
            login.useNativeSQL();
        }
        this.session = new Project(login).createDatabaseSession();
        this.session.setLogLevel(this.sessionLogLevel);
        this.session.setLog((Writer)new OutputStreamWriter(System.out));
        this.session.login();
    }

    public void logout() {
        this.session.logout();
    }

    public static void main(String[] args) {
        new PromptTestRunner().run(args);
        System.exit(0);
    }

    public void run(String[] argv) {
        if (argv.length < 1 || argv.length > 5) {
            this.printUsageAndExit();
        }
        for (int i = 0; i < argv.length; ++i) {
            this.processArguments(argv[i]);
        }
        try {
            if (this.createDbConnection) {
                this.login();
            }
            TestExecutor executor = new TestExecutor();
            executor.setSession((Session)this.session);
            if (this.regressionLog != null) {
                executor.setRegressionLog(this.regressionLog);
            }
            if (this.shouldHandleErrors) {
                executor.handleErrors();
            }
            if (this.testEntity != null && this.testModel != null) {
                this.testModel.setExecutor(executor);
                this.testModel.setupEntity();
                executor.execute(this.testEntity);
                executor.logResultForTestEntity(this.testEntity);
                executor.logRegressionResultForTestEntity(this.testEntity);
            } else if (this.testModel != null) {
                if (this.createDbConnection) {
                    LoadBuildSystem.loadBuild.userName = this.testModel.getName();
                    LoadBuildSystem.loadBuild.loginChoice = executor.getSession().getLogin().getConnectionString();
                }
                executor.runTest(this.testModel);
                if (this.createDbConnection && this.saveResults && LoadBuildSystem.loadBuild != null && !LoadBuildSystem.loadBuild.isEmpty()) {
                    LoadBuildSystem loadBuildSystem = new LoadBuildSystem();
                    loadBuildSystem.saveLoadBuild();
                }
            } else {
                PromptTestRunner.log("\nNo test model specified.");
            }
            if (this.createDbConnection) {
                this.logout();
            }
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
    }

    protected void processArguments(String arg) {
        if (arg.startsWith(TEST_MODEL_FLAG)) {
            String testModelName = arg.substring(TEST_MODEL_FLAG.length());
            if (testModelName.toLowerCase().equals("lightrunalltestmodel")) {
                this.testModel = TestRunModel.buildLRGTestModel();
            } else {
                try {
                    this.testModel = (TestModel)Class.forName(testModelName).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.printUsageAndExit();
                }
            }
        } else if (arg.startsWith(TEST_ENTITY_FLAG)) {
            String testEntityName = arg.substring(TEST_ENTITY_FLAG.length());
            try {
                this.testEntity = (TestEntity)Class.forName(testEntityName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.printUsageAndExit();
            }
        } else if (arg.startsWith(REGRESSION_LOG_FLAG)) {
            String regressionLogFileName = arg.substring(REGRESSION_LOG_FLAG.length());
            try {
                this.regressionLog = new FileWriter(regressionLogFileName, true);
            }
            catch (IOException e) {
                PromptTestRunner.log("\nWrite regression log file " + regressionLogFileName + " error!");
                System.exit(1);
            }
        } else if (arg.startsWith(USE_NATIVE_SQL_FLAG)) {
            this.useNativeSQL = arg.substring(USE_NATIVE_SQL_FLAG.length()).equalsIgnoreCase("true");
        } else if (arg.startsWith(SAVE_RESULTS_FLAG)) {
            this.saveResults = arg.substring(SAVE_RESULTS_FLAG.length()).equalsIgnoreCase("true");
        } else if (arg.startsWith(CREATE_DB_CONNECTION_FLAG)) {
            this.createDbConnection = !arg.substring(CREATE_DB_CONNECTION_FLAG.length()).equalsIgnoreCase("false");
        } else {
            PromptTestRunner.log("Invalid argument: " + arg);
            this.printUsageAndExit();
        }
    }

    public void printUsageAndExit() {
        PromptTestRunner.log("\nUsage:\t java <Java VM arguments> org.eclipse.persistence.testing.framework.PromptTestRunner testmodel=<testModel> [testentity=<testEntity> regressionlog=<regressionLogFile> usenativesql=<shouldUseNativeSQL> saveresults=<shouldSaveResults>]createdbconnection=<shouldCreateDbConnection>]");
        PromptTestRunner.log("\n\tWhere:");
        PromptTestRunner.log("\n\t<Java VM arguments>: Required, specifies Database Login properties");
        PromptTestRunner.log("\n\t<testModel>: Required, specifies test model class name");
        PromptTestRunner.log("\n\t<testEntity>: Optional, specifies test entity class name(test model, test suite or test case). When specified, the runner will setup the test model and run the test entity only");
        PromptTestRunner.log("\n\t<regressionLogFile>: Optional, specifies file name of regression log, in which there is no label-related info.");
        PromptTestRunner.log("\n\t<shouldUseNativeSQL>: Optional, valid values are 'true' and 'false', default value is 'false'.");
        PromptTestRunner.log("\n\t<shouldSaveResults>: Optional, valid values are 'true' and 'false', default value is 'false'.");
        PromptTestRunner.log("\n\t<shouldCreateDbConnection>: Optional, valid values are 'true' and 'false', default value is 'true'.");
        PromptTestRunner.log("\n\tExample:");
        PromptTestRunner.log("\n\tjava");
        PromptTestRunner.log("\n\t\t-Ddb.driver=oracle.jdbc.OracleDriver");
        PromptTestRunner.log("\n\t\t-Ddb.url=jdbc:oracle:thin:@localhost:1521:ORCL");
        PromptTestRunner.log("\n\t\t-Ddb.user=scott");
        PromptTestRunner.log("\n\t\t-Ddb.pwd=tiger");
        PromptTestRunner.log("\n\t\t-Ddb.platform=org.eclipse.persistence.platform.database.OraclePlatform");
        PromptTestRunner.log("\n\t\t-Declipselink.logging.level=info");
        PromptTestRunner.log("\n\torg.eclipse.persistence.testing.Testframework.PromptTestRunner");
        PromptTestRunner.log("\n\t\ttestmodel=org.eclipse.persistence.testing.FeatureTests.FeatureTestModel ");
        PromptTestRunner.log("\n\t\ttestentity=org.eclipse.persistence.testing.FeatureTests.OptimisticLockingDeleteRowTest ");
        PromptTestRunner.log("\n\t\tregressionlog=C:\\temp\\OptimisticLockingDeleteRowTest.log");
        System.exit(0);
    }

    public void getLoginProperties() {
        String loggingLevel = System.getProperty(LOGGING_LEVEL_KEY, LOGGING_LEVEL_DEFAULT);
        this.sessionLogLevel = loggingLevel.equalsIgnoreCase("off") ? 8 : (loggingLevel.equalsIgnoreCase("severe") ? 7 : (loggingLevel.equalsIgnoreCase("warning") ? 6 : (loggingLevel.equalsIgnoreCase("config") ? 4 : (loggingLevel.equalsIgnoreCase("fine") ? 3 : (loggingLevel.equalsIgnoreCase("finer") ? 2 : (loggingLevel.equalsIgnoreCase("finest") ? 1 : (loggingLevel.equalsIgnoreCase("all") ? 0 : 5)))))));
        this.driverClass = System.getProperty(DB_DRIVER_KEY, DB_DRIVER_DEFAULT);
        this.databaseURL = System.getProperty(DB_URL_KEY, DB_URL_DEFAULT);
        this.username = System.getProperty(DB_USER_KEY, DB_USER_DEFAULT);
        this.password = System.getProperty(DB_PWD_KEY, DB_PWD_DEFAULT);
        this.databasePlatform = System.getProperty(DB_PLATFORM_KEY, DB_PLATFORM_DEFAULT);
    }
}

