/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.jms;

import jakarta.jms.Session;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.ConnectionMetaData;
import jakarta.resource.cci.Interaction;
import jakarta.resource.cci.LocalTransaction;
import jakarta.resource.cci.ResultSetInfo;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnectionMetaData;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnectionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSInteraction;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSTransaction;

public class CciJMSConnection
implements Connection {
    protected jakarta.jms.Connection connection;
    protected CciJMSConnectionSpec connectionSpec;
    protected Session session;
    protected CciJMSTransaction transaction;

    public CciJMSConnection(Session session, jakarta.jms.Connection conn, CciJMSConnectionSpec spec) {
        this.session = session;
        this.connection = conn;
        this.connectionSpec = spec;
        this.transaction = new CciJMSTransaction(this);
    }

    public jakarta.jms.Connection getConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public void close() throws EISException {
        try {
            this.getSession().close();
            this.getConnection().close();
        }
        catch (Exception exception) {
            throw EISException.createException((Exception)exception);
        }
    }

    public Interaction createInteraction() {
        return new CciJMSInteraction(this);
    }

    public CciJMSConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public LocalTransaction getLocalTransaction() {
        return this.transaction;
    }

    public CciJMSTransaction getJMSTransaction() {
        return this.transaction;
    }

    public ConnectionMetaData getMetaData() {
        return new CciJMSConnectionMetaData(this);
    }

    public ResultSetInfo getResultSetInfo() {
        throw ValidationException.operationNotSupported((String)"getResultSetInfo");
    }
}

