/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import junit.framework.Test;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.platform.database.TimesTenPlatform;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.employee.EmployeeDeleteTest;
import org.eclipse.persistence.testing.tests.employee.ProjectDeleteTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLValidationTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class SessionsXMLBasicTestModel
extends TestModel {
    Session originalSession = null;
    Session newXMLSession = null;

    public SessionsXMLBasicTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the employee demo read through the sessions.xml and project.xml.");
    }

    public SessionsXMLBasicTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addTests() {
        this.addTest((Test)SessionsXMLBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getValidationTests());
    }

    public void addSRGTests() {
        this.addTest((Test)SessionsXMLBasicTestModel.getSRGReadObjectTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getSRGUpdateObjectTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getSRGInsertObjectTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getSRGDeleteObjectTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getSRGReadAllTestSuite());
        this.addTest((Test)SessionsXMLBasicTestModel.getSRGValidationTests());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample3()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        Project project = (Project)manager.getObject(largeProjectClass, "0001");
        ReadObjectTest test = new ReadObjectTest((Object)project);
        test.setQuery(new ReadObjectQuery(Project.class, new ExpressionBuilder().get("id").equal((Object)project.getId())));
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getValidationTests() {
        TestSuite suite = new TestSuite();
        suite.setName("Sessions.xml validation tests");
        SessionsXMLValidationTest.addTestsTo(suite);
        return suite;
    }

    public static TestSuite getSRGDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getSRGInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample3()));
        return suite;
    }

    public static TestSuite getSRGReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        return suite;
    }

    public static TestSuite getSRGReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        Project project = (Project)manager.getObject(largeProjectClass, "0001");
        ReadObjectTest test = new ReadObjectTest((Object)project);
        test.setQuery(new ReadObjectQuery(Project.class, new ExpressionBuilder().get("id").equal((Object)project.getId())));
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getSRGUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getSRGValidationTests() {
        TestSuite suite = new TestSuite();
        suite.setName("Sessions.xml validation tests");
        SessionsXMLValidationTest.addTestsTo(suite);
        return suite;
    }

    public void setup() {
        this.originalSession = this.getSession();
        if (this.getSession().getPlatform() instanceof TimesTenPlatform) {
            throw new TestProblemException("This model is not intended for TimesTen databases.");
        }
        XMLSessionConfigLoader xmlLoader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/sessions.xml");
        this.newXMLSession = SessionManager.getManager().getSession(xmlLoader, "EmployeeSession", ((Object)((Object)this)).getClass().getClassLoader(), false, true);
        this.newXMLSession.setSessionLog(this.originalSession.getSessionLog());
        this.newXMLSession.setLogLevel(this.originalSession.getLogLevel());
        ((DatabaseSession)this.originalSession).logout();
        this.newXMLSession.getLogin().setPlatform((Platform)this.originalSession.getLogin().getPlatform());
        this.newXMLSession.getLogin().setDriverClassName(this.originalSession.getLogin().getDriverClassName());
        this.newXMLSession.getLogin().setConnectionString(this.originalSession.getLogin().getConnectionString());
        this.newXMLSession.getLogin().setUserName(this.originalSession.getLogin().getUserName());
        this.newXMLSession.getLogin().setEncryptedPassword(this.originalSession.getLogin().getPassword());
        ((DatabaseSession)this.newXMLSession).login();
        this.getExecutor().setSession(this.newXMLSession);
        new EmployeeSystem().createTables((DatabaseSession)this.newXMLSession);
        new EmployeeSystem().populate((DatabaseSession)this.newXMLSession);
    }

    public void reset() {
        this.getExecutor().setSession(this.originalSession);
        if (this.newXMLSession != null) {
            if (this.newXMLSession.isConnected()) {
                ((DatabaseSession)this.newXMLSession).logout();
            }
            this.newXMLSession = null;
        }
    }
}

