/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamicpersist;

import org.eclipse.persistence.internal.dynamicpersist.BaseEntity;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityCollectionWrapper;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseEntityClassLoader
extends ClassLoader {
    private static final String BASE_ENTITY_CLASSNAME_SLASHES = BaseEntity.class.getName().replace('.', '/');
    public static final String COLLECTION_WRAPPER_SUFFIX = "_CollectionWrapper";
    private static final String BASE_ENTITY_COLLECTION_WRAPPER_CLASSNAME_SLASHES = BaseEntityCollectionWrapper.class.getName().replace('.', '/');
    protected boolean generateSubclasses = true;

    public BaseEntityClassLoader() {
        this(BaseEntityClassLoader.class.getClassLoader());
    }

    public BaseEntityClassLoader(ClassLoader parentLoader) {
        super(parentLoader);
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        if (!this.generateSubclasses) {
            throw new ClassNotFoundException(className);
        }
        try {
            byte[] data = this.generateClassBytes(className);
            return this.defineClass(className, data, 0, data.length);
        }
        catch (ClassFormatError e) {
            throw new ClassNotFoundException(className, e);
        }
    }

    protected byte[] generateClassBytes(String className) {
        String classNameAsSlashes = className.replace('.', '/');
        ClassWriter cw = new ClassWriter(true);
        if (className.endsWith(COLLECTION_WRAPPER_SUFFIX)) {
            cw.visit(49, 33, classNameAsSlashes, BASE_ENTITY_COLLECTION_WRAPPER_CLASSNAME_SLASHES, null, null);
            CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(183, BASE_ENTITY_COLLECTION_WRAPPER_CLASSNAME_SLASHES, "<init>", "()V");
            cv.visitInsn(177);
            cv.visitMaxs(0, 0);
        } else {
            cw.visit(49, 33, classNameAsSlashes, BASE_ENTITY_CLASSNAME_SLASHES, null, null);
            cw.visitField(9, "NUM_ATTRIBUTES", "I", null, null);
            CodeVisitor cv = cw.visitMethod(8, "<clinit>", "()V", null, null);
            cv.visitInsn(4);
            cv.visitFieldInsn(179, classNameAsSlashes, "NUM_ATTRIBUTES", "I");
            cv.visitInsn(177);
            cv.visitMaxs(0, 0);
            cv = cw.visitMethod(9, "setNumAttributes", "(Ljava/lang/Integer;)V", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
            cv.visitFieldInsn(179, classNameAsSlashes, "NUM_ATTRIBUTES", "I");
            cv.visitInsn(177);
            cv.visitMaxs(0, 0);
            cv = cw.visitMethod(9, "getNumAttributes", "()I", null, null);
            cv.visitFieldInsn(178, classNameAsSlashes, "NUM_ATTRIBUTES", "I");
            cv.visitInsn(172);
            cv.visitMaxs(0, 0);
            cv = cw.visitMethod(1, "<init>", "()V", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(183, BASE_ENTITY_CLASSNAME_SLASHES, "<init>", "()V");
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(184, classNameAsSlashes, "getNumAttributes", "()I");
            cv.visitTypeInsn(189, "java/lang/Object");
            cv.visitFieldInsn(181, classNameAsSlashes, "fields", "[Ljava/lang/Object;");
            cv.visitInsn(177);
            cv.visitMaxs(0, 0);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    public void dontGenerateSubclasses() {
        this.generateSubclasses = false;
    }
}

