/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataColumn;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

public class DiscriminatorColumnMetadata
extends MetadataColumn {
    private Integer m_length;
    private String m_discriminatorType;

    public DiscriminatorColumnMetadata() {
        super("<discriminator-column>");
    }

    public DiscriminatorColumnMetadata(MetadataAnnotation discriminatorColumn, MetadataAccessibleObject accessibleObject) {
        super(discriminatorColumn, accessibleObject);
        if (discriminatorColumn != null) {
            this.m_length = (Integer)discriminatorColumn.getAttribute("length");
            this.m_discriminatorType = (String)discriminatorColumn.getAttribute("discriminatorType");
        }
    }

    public String getDiscriminatorType() {
        return this.m_discriminatorType;
    }

    public DatabaseField getDatabaseField() {
        DatabaseField field = super.getDatabaseField();
        field.setLength(MetadataHelper.getValue(this.m_length, 31).intValue());
        if (this.m_discriminatorType == null || this.m_discriminatorType.equals(DiscriminatorType.STRING.name())) {
            field.setType(String.class);
        } else if (this.m_discriminatorType.equals(DiscriminatorType.CHAR.name())) {
            field.setType(Character.class);
        } else {
            field.setType(Integer.class);
        }
        return field;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public DatabaseField process(MetadataDescriptor descriptor, String annotatedElementName, String loggingCtx) {
        DatabaseField field = this.getDatabaseField();
        boolean useDelimitedIdentifier = descriptor.getProject() != null ? descriptor.getProject().useDelimitedIdentifier() : false;
        field.setName(MetadataHelper.getName(field.getName(), "DTYPE", loggingCtx, descriptor.getLogger(), annotatedElementName), Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
        if (useDelimitedIdentifier) {
            field.setUseDelimiters(useDelimitedIdentifier);
        }
        field.setTable(descriptor.getPrimaryTable());
        return field;
    }

    public void setDiscriminatorType(String descriminatorType) {
        this.m_discriminatorType = descriminatorType;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }
}

