/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.rwt.internal.util.ParamCheck;

final class WrappedRequest
extends HttpServletRequestWrapper {
    private final Map parameterMap;

    WrappedRequest(HttpServletRequest request, Map paramMap) {
        super(request);
        ParamCheck.notNull(paramMap, "paramMap");
        this.parameterMap = new HashMap(paramMap);
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.parameterMap.put(name, request.getParameterValues(name));
        }
    }

    public String getParameter(String name) {
        String[] value = (String[])this.parameterMap.get(name);
        String result = null;
        if (value != null) {
            result = value[0];
        }
        return result;
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.parameterMap.get(name);
        String[] result = null;
        if (values != null) {
            result = new String[values.length];
            System.arraycopy(values, 0, result, 0, values.length);
        }
        return result;
    }

    public Enumeration getParameterNames() {
        final Iterator iterator = this.parameterMap.keySet().iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }
}

