/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.RWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.graphics.InternalImage;

public class InternalImageFactory {
    private final Map cache = new HashMap();
    private final Object cacheLock = new Object();

    InternalImageFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalImage findInternalImage(String fileName) {
        InternalImage result;
        Object object = this.cacheLock;
        synchronized (object) {
            result = (InternalImage)this.cache.get(fileName);
            if (result == null) {
                result = InternalImageFactory.createInternalImage(fileName);
                this.cache.put(fileName, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalImage findInternalImage(InputStream stream) {
        InternalImage result;
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        ImageData imageData = InternalImageFactory.readImageData(bufferedStream);
        String path = InternalImageFactory.createGeneratedImagePath(imageData);
        Object object = this.cacheLock;
        synchronized (object) {
            result = (InternalImage)this.cache.get(path);
            if (result == null) {
                result = InternalImageFactory.createInternalImage(path, bufferedStream, imageData);
                this.cache.put(path, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalImage findInternalImage(ImageData imageData) {
        InternalImage result;
        String path = InternalImageFactory.createGeneratedImagePath(imageData);
        Object object = this.cacheLock;
        synchronized (object) {
            result = (InternalImage)this.cache.get(path);
            if (result == null) {
                InputStream stream = InternalImageFactory.createInputStream(imageData);
                result = InternalImageFactory.createInternalImage(path, stream, imageData);
                this.cache.put(path, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalImage findInternalImage(String key, InputStream inputStream) {
        InternalImage result;
        Object object = this.cacheLock;
        synchronized (object) {
            result = (InternalImage)this.cache.get(key);
            if (result == null) {
                BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
                ImageData imageData = InternalImageFactory.readImageData(bufferedStream);
                String path = InternalImageFactory.createGeneratedImagePath(imageData);
                result = InternalImageFactory.createInternalImage(path, bufferedStream, imageData);
                this.cache.put(key, result);
            }
        }
        return result;
    }

    static ImageData readImageData(InputStream stream) throws SWTException {
        stream.mark(Integer.MAX_VALUE);
        ImageData result = new ImageData(stream);
        try {
            stream.reset();
        }
        catch (IOException shouldNotHappen) {
            String msg = "Could not reset input stream after reading image";
            throw new RuntimeException(msg, shouldNotHappen);
        }
        return result;
    }

    static InputStream createInputStream(ImageData imageData) {
        ImageLoader imageLoader = new ImageLoader();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.save(outputStream, InternalImageFactory.getOutputFormat(imageData));
        byte[] bytes = outputStream.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InternalImage createInternalImage(String fileName) {
        try {
            InternalImage result;
            FileInputStream stream = new FileInputStream(fileName);
            try {
                result = InternalImageFactory.createInternalImage(stream);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                stream.close();
                return result;
            }
        }
        catch (IOException e) {
            throw new SWTException(39, e.getMessage());
        }
    }

    private static InternalImage createInternalImage(InputStream stream) {
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        ImageData imageData = InternalImageFactory.readImageData(bufferedStream);
        String path = InternalImageFactory.createGeneratedImagePath(imageData);
        return InternalImageFactory.createInternalImage(path, bufferedStream, imageData);
    }

    private static InternalImage createInternalImage(String path, InputStream stream, ImageData imageData) {
        RWT.getResourceManager().register(path, stream);
        return new InternalImage(path, imageData.width, imageData.height);
    }

    private static int getOutputFormat(ImageData imageData) {
        int result = imageData.type;
        if (imageData.type == -1) {
            result = 5;
        }
        return result;
    }

    private static String createGeneratedImagePath(ImageData data) {
        int hashCode = InternalImageFactory.getHashCode(data);
        return "generated/" + Integer.toHexString(hashCode);
    }

    private static int getHashCode(ImageData imageData) {
        int result;
        if (imageData.data == null) {
            result = 0;
        } else {
            result = 1;
            int i = 0;
            while (i < imageData.data.length) {
                result = 31 * result + imageData.data[i];
                ++i;
            }
        }
        if (imageData.palette != null) {
            if (imageData.palette.isDirect) {
                result = result * 29 + imageData.palette.redMask;
                result = result * 29 + imageData.palette.greenMask;
                result = result * 29 + imageData.palette.blueMask;
            } else {
                RGB[] rgb = imageData.palette.getRGBs();
                int i = 0;
                while (i < rgb.length) {
                    result = result * 37 + rgb[i].red;
                    result = result * 37 + rgb[i].green;
                    result = result * 37 + rgb[i].blue;
                    ++i;
                }
            }
        }
        result = result * 41 + imageData.alpha;
        result = result * 41 + imageData.transparentPixel;
        result = result * 41 + imageData.type;
        result = result * 41 + imageData.bytesPerLine;
        result = result * 41 + imageData.scanlinePad;
        result = result * 41 + imageData.maskPad;
        return result;
    }
}

