/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.config;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.rap.ui.internal.launch.rwt.config.EntryPointValidator;
import org.eclipse.rap.ui.internal.launch.rwt.config.ProjectValidator;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.config.ServletPathValidator;
import org.eclipse.rap.ui.internal.launch.rwt.config.ValidationResult;
import org.eclipse.rap.ui.internal.launch.rwt.config.Validator;
import org.eclipse.rap.ui.internal.launch.rwt.config.WebXmlLocationValidator;

public class ValidationRunner {
    private final RWTLaunchConfig config;
    private ValidationResult validationResult;

    public ValidationRunner(RWTLaunchConfig config) {
        this.config = config;
        this.validationResult = new ValidationResult();
    }

    public void validate() {
        this.validationResult = new ValidationResult();
        Validator[] validators = this.createValidators();
        int i = 0;
        while (i < validators.length) {
            validators[i].validate();
            ++i;
        }
    }

    public IStatus[] getErrors() {
        return this.validationResult.getErrors();
    }

    public IStatus[] getWarnings() {
        return this.validationResult.getWarnings();
    }

    private Validator[] createValidators() {
        return new Validator[]{new ProjectValidator(this.config, this.validationResult), new EntryPointValidator(this.config, this.validationResult), new WebXmlLocationValidator(this.config, this.validationResult), new ServletPathValidator(this.config, this.validationResult)};
    }
}

