/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.clabelkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.internal.custom.clabelkit.CLabelOperationHandler;
import org.eclipse.swt.internal.custom.clabelkit.CLabelThemeAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.widgets.Widget;

public final class CLabelLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Label";
    private static final String[] ALLOWED_STYLES = new String[]{"SHADOW_IN", "SHADOW_OUT", "SHADOW_NONE", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_LEFT_MARGIN = "leftMargin";
    private static final String PROP_TOP_MARGIN = "topMargin";
    private static final String PROP_RIGHT_MARGIN = "rightMargin";
    private static final String PROP_BOTTOM_MARGIN = "bottomMargin";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final String DEFAULT_ALIGNMENT = "left";

    @Override
    public void preserveValues(Widget widget) {
        CLabel label = (CLabel)widget;
        ControlLCAUtil.preserveValues(label);
        WidgetLCAUtil.preserveCustomVariant(label);
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_TEXT, label.getText());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_IMAGE, label.getImage());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_ALIGNMENT, CLabelLCA.getAlignment(label));
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_LEFT_MARGIN, label.getLeftMargin());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_TOP_MARGIN, label.getTopMargin());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_RIGHT_MARGIN, label.getRightMargin());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_BOTTOM_MARGIN, label.getBottomMargin());
        WidgetLCAUtil.preserveBackgroundGradient(label);
    }

    @Override
    public void renderInitialization(Widget widget) throws IOException {
        CLabel clabel = (CLabel)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(clabel, TYPE);
        remoteObject.setHandler(new CLabelOperationHandler(clabel));
        remoteObject.set("parent", WidgetUtil.getId(clabel.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(clabel, ALLOWED_STYLES)));
        remoteObject.set("appearance", "clabel");
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_MARKUP_ENABLED, MarkupUtil.isMarkupEnabledFor(clabel), false);
    }

    @Override
    public void renderChanges(Widget widget) throws IOException {
        CLabel clabel = (CLabel)widget;
        ControlLCAUtil.renderChanges(clabel);
        WidgetLCAUtil.renderCustomVariant(clabel);
        CLabelLCA.renderText(clabel);
        CLabelLCA.renderMnemonicIndex(clabel);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_IMAGE, clabel.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_ALIGNMENT, CLabelLCA.getAlignment(clabel), DEFAULT_ALIGNMENT);
        CLabelLCA.renderMargins(clabel);
        WidgetLCAUtil.renderBackgroundGradient(clabel);
    }

    private static void renderMargins(CLabel clabel) {
        BoxDimensions padding = CLabelLCA.getThemeAdapter(clabel).getPadding(clabel);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_LEFT_MARGIN, clabel.getLeftMargin(), padding.left);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_TOP_MARGIN, clabel.getTopMargin(), padding.top);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_RIGHT_MARGIN, clabel.getRightMargin(), padding.right);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_BOTTOM_MARGIN, clabel.getBottomMargin(), padding.bottom);
    }

    private static String getAlignment(CLabel clabel) {
        int alignment = clabel.getAlignment();
        String result = (alignment & 0x4000) != 0 ? DEFAULT_ALIGNMENT : ((alignment & 0x1000000) != 0 ? "center" : ((alignment & 0x20000) != 0 ? "right" : DEFAULT_ALIGNMENT));
        return result;
    }

    private static void renderText(CLabel clabel) {
        String newValue = clabel.getText();
        if (WidgetLCAUtil.hasChanged(clabel, PROP_TEXT, newValue, null)) {
            String text = newValue;
            if (!MarkupUtil.isMarkupEnabledFor(clabel)) {
                text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            }
            RemoteObjectFactory.getRemoteObject(clabel).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(CLabel clabel) {
        int mnemonicIndex;
        String text;
        if (!MarkupUtil.isMarkupEnabledFor(clabel) && WidgetLCAUtil.hasChanged(clabel, PROP_TEXT, text = clabel.getText(), null) && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            RemoteObjectFactory.getRemoteObject(clabel).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }

    private static CLabelThemeAdapter getThemeAdapter(CLabel clabel) {
        return (CLabelThemeAdapter)clabel.getAdapter(ThemeAdapter.class);
    }
}

