/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.remote;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;

public class DeferredRemoteObject
extends RemoteObjectImpl {
    private final List<RenderRunnable> renderQueue = new ArrayList<RenderRunnable>();
    private boolean created;

    public DeferredRemoteObject(final String id, final String createType) {
        super(id, createType);
        if (createType != null) {
            this.renderQueue.add(new RenderRunnable(){

                @Override
                public void render(ProtocolMessageWriter writer) {
                    writer.appendCreate(id, createType);
                }
            });
        }
    }

    @Override
    public void set(final String name, final int value) {
        super.set(name, value);
        this.renderQueue.add(new RenderRunnable(){

            @Override
            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(DeferredRemoteObject.this.getId(), name, value);
            }
        });
    }

    @Override
    public void set(final String name, final double value) {
        super.set(name, value);
        this.renderQueue.add(new RenderRunnable(){

            @Override
            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(DeferredRemoteObject.this.getId(), name, value);
            }
        });
    }

    @Override
    public void set(final String name, final boolean value) {
        super.set(name, value);
        this.renderQueue.add(new RenderRunnable(){

            @Override
            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(DeferredRemoteObject.this.getId(), name, value);
            }
        });
    }

    @Override
    public void set(final String name, final String value) {
        super.set(name, value);
        this.renderQueue.add(new RenderRunnable(){

            @Override
            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(DeferredRemoteObject.this.getId(), name, value);
            }
        });
    }

    @Override
    public void set(final String name, final JsonValue value) {
        super.set(name, value);
        this.renderQueue.add(new RenderRunnable(){

            @Override
            public void render(ProtocolMessageWriter writer) {
                writer.appendSet(DeferredRemoteObject.this.getId(), name, value);
            }
        });
    }

    @Override
    public void listen(final String eventType, final boolean listen) {
        super.listen(eventType, listen);
        this.renderQueue.add(new RenderRunnable(){

            @Override
            public void render(ProtocolMessageWriter writer) {
                writer.appendListen(DeferredRemoteObject.this.getId(), eventType, listen);
            }
        });
    }

    @Override
    public void call(final String method, final JsonObject parameters) {
        super.call(method, parameters);
        this.renderQueue.add(new RenderRunnable(){

            @Override
            public void render(ProtocolMessageWriter writer) {
                writer.appendCall(DeferredRemoteObject.this.getId(), method, parameters);
            }
        });
    }

    @Override
    public void destroy() {
        super.destroy();
        this.renderQueue.add(new RenderRunnable(){

            @Override
            public void render(ProtocolMessageWriter writer) {
                writer.appendDestroy(DeferredRemoteObject.this.getId());
            }
        });
    }

    public void render(ProtocolMessageWriter writer) {
        if (!this.isDestroyed() || this.created) {
            for (RenderRunnable runnable : this.renderQueue) {
                runnable.render(writer);
            }
            this.created = true;
        }
        this.renderQueue.clear();
    }

    private static interface RenderRunnable
    extends Serializable {
        public void render(ProtocolMessageWriter var1);
    }
}

