/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ICountable;
import org.eclipse.core.expressions.IIterable;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.w3c.dom.Element;

public class Expressions {
    private static WeakHashMap<Class<?>, Map<String, Boolean>> fgKnownClasses;
    private static WeakHashMap<ClassLoader, Set<String>> fgNotFoundClasses;
    public static final boolean TRACING;
    public static final Object[] EMPTY_ARGS;

    static {
        TRACING = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.expressions/tracePropertyResolving"));
        EMPTY_ARGS = new Object[0];
    }

    private Expressions() {
    }

    public static boolean isInstanceOf(Object element, String type) {
        if (element == null) {
            return false;
        }
        return Expressions.isSubtype(element.getClass(), type);
    }

    private static synchronized boolean isSubtype(Class<?> clazz, String type) {
        boolean isSubtype;
        Boolean obj;
        WeakHashMap<Class<?>, Map<String, Boolean>> knownClassesMap = Expressions.getKnownClasses();
        Map<String, Boolean> nameMap = knownClassesMap.get(clazz);
        if (nameMap != null && (obj = nameMap.get(type)) != null) {
            return obj;
        }
        if (nameMap == null) {
            nameMap = new HashMap<String, Boolean>();
            knownClassesMap.put(clazz, nameMap);
        }
        nameMap.put(type, (isSubtype = Expressions.uncachedIsSubtype(clazz, type)) ? Boolean.TRUE : Boolean.FALSE);
        return isSubtype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<?> loadClass(ClassLoader classLoader, String className) {
        Class<Expressions> clazz = Expressions.class;
        synchronized (Expressions.class) {
            Set<String> classNames;
            WeakHashMap<ClassLoader, Set<String>> cache;
            block10: {
                cache = Expressions.getNotFoundClasses();
                classNames = cache.get(classLoader);
                if (classNames == null || !classNames.contains(className)) break block10;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            try {
                return Class.forName(className, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Expressions.class;
                synchronized (Expressions.class) {
                    classNames = cache.get(classLoader);
                    if (classNames == null) {
                        classNames = new HashSet<String>();
                        cache.put(classLoader, classNames);
                    }
                    classNames.add(className);
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return null;
                }
            }
        }
    }

    private static WeakHashMap<Class<?>, Map<String, Boolean>> getKnownClasses() {
        Expressions.createClassCaches();
        return fgKnownClasses;
    }

    private static WeakHashMap<ClassLoader, Set<String>> getNotFoundClasses() {
        Expressions.createClassCaches();
        return fgNotFoundClasses;
    }

    private static void createClassCaches() {
        if (fgKnownClasses == null) {
            BundleListener listener;
            fgKnownClasses = new WeakHashMap();
            fgNotFoundClasses = new WeakHashMap();
            BundleContext bundleContext = ExpressionPlugin.getDefault().getBundleContext();
            ExpressionPlugin.fgBundleListener = listener = new BundleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void bundleChanged(BundleEvent event) {
                    if (event.getType() != 4) return;
                    Class<Expressions> clazz = Expressions.class;
                    synchronized (Expressions.class) {
                        fgKnownClasses.clear();
                        fgNotFoundClasses.clear();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            };
            bundleContext.addBundleListener(listener);
        }
    }

    public static boolean uncachedIsSubtype(Class<?> clazz, String type) {
        Class<?>[] interfaces;
        if (clazz.getName().equals(type)) {
            return true;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && Expressions.uncachedIsSubtype(superClass, type)) {
            return true;
        }
        Class<?>[] classArray = interfaces = clazz.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            if (Expressions.uncachedIsSubtype(interfaze, type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void checkAttribute(String name, String value) throws CoreException {
        if (value == null) {
            throw new CoreException((IStatus)new ExpressionStatus(50, Messages.format(ExpressionMessages.Expression_attribute_missing, name)));
        }
    }

    public static void checkAttribute(String name, String value, String[] validValues) throws CoreException {
        Expressions.checkAttribute(name, value);
        String[] stringArray = validValues;
        int n = validValues.length;
        int n2 = 0;
        while (n2 < n) {
            String validValue = stringArray[n2];
            if (value.equals(validValue)) {
                return;
            }
            ++n2;
        }
        throw new CoreException((IStatus)new ExpressionStatus(51, Messages.format(ExpressionMessages.Expression_attribute_invalid_value, value)));
    }

    public static void checkCollection(Object var, Expression expression) throws CoreException {
        if (var instanceof Collection) {
            return;
        }
        throw new CoreException((IStatus)new ExpressionStatus(3, Messages.format(ExpressionMessages.Expression_variable_not_a_collection, expression.toString())));
    }

    public static void checkList(Object var, Expression expression) throws CoreException {
        if (var instanceof List) {
            return;
        }
        throw new CoreException((IStatus)new ExpressionStatus(4, Messages.format(ExpressionMessages.Expression_variable_not_a_list, expression.toString())));
    }

    public static IIterable<?> getAsIIterable(Object var, Expression expression) throws CoreException {
        if (var instanceof IIterable) {
            return (IIterable)var;
        }
        IAdapterManager manager = Platform.getAdapterManager();
        IIterable result = (IIterable)manager.getAdapter(var, IIterable.class);
        if (result != null) {
            return result;
        }
        if (manager.queryAdapter(var, IIterable.class.getName()) == 1) {
            return null;
        }
        throw new CoreException((IStatus)new ExpressionStatus(3, Messages.format(ExpressionMessages.Expression_variable_not_iterable, expression.toString())));
    }

    public static ICountable getAsICountable(Object var, Expression expression) throws CoreException {
        if (var instanceof ICountable) {
            return (ICountable)var;
        }
        IAdapterManager manager = Platform.getAdapterManager();
        ICountable result = (ICountable)manager.getAdapter(var, ICountable.class);
        if (result != null) {
            return result;
        }
        if (manager.queryAdapter(var, ICountable.class.getName()) == 1) {
            return null;
        }
        throw new CoreException((IStatus)new ExpressionStatus(3, Messages.format(ExpressionMessages.Expression_variable_not_countable, expression.toString())));
    }

    public static boolean getOptionalBooleanAttribute(IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static boolean getOptionalBooleanAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value.isEmpty()) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static Object[] getArguments(IConfigurationElement element, String attributeName) throws CoreException {
        String args = element.getAttribute(attributeName);
        if (args != null) {
            return Expressions.parseArguments(args);
        }
        return EMPTY_ARGS;
    }

    public static Object[] getArguments(Element element, String attributeName) throws CoreException {
        String args = element.getAttribute(attributeName);
        if (!args.isEmpty()) {
            return Expressions.parseArguments(args);
        }
        return EMPTY_ARGS;
    }

    public static Object[] parseArguments(String args) throws CoreException {
        int comma;
        ArrayList<Object> result = new ArrayList<Object>();
        int start = 0;
        while ((comma = Expressions.findNextComma(args, start)) != -1) {
            result.add(Expressions.convertArgument(args.substring(start, comma).trim()));
            start = comma + 1;
        }
        result.add(Expressions.convertArgument(args.substring(start).trim()));
        return result.toArray();
    }

    private static int findNextComma(String str, int start) throws CoreException {
        boolean inString = false;
        int i = start;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == ',' && !inString) {
                return i;
            }
            if (ch == '\'') {
                if (!inString) {
                    inString = true;
                } else if (i + 1 < str.length() && str.charAt(i + 1) == '\'') {
                    ++i;
                } else {
                    inString = false;
                }
            } else if (ch == ',' && !inString) {
                return i;
            }
            ++i;
        }
        if (inString) {
            throw new CoreException((IStatus)new ExpressionStatus(303, Messages.format(ExpressionMessages.Expression_string_not_terminated, str)));
        }
        return -1;
    }

    public static Object convertArgument(String arg) throws CoreException {
        if (arg == null) {
            return null;
        }
        if (arg.isEmpty()) {
            return arg;
        }
        if (arg.charAt(0) == '\'' && arg.charAt(arg.length() - 1) == '\'') {
            return Expressions.unEscapeString(arg.substring(1, arg.length() - 1));
        }
        if ("true".equals(arg)) {
            return Boolean.TRUE;
        }
        if ("false".equals(arg)) {
            return Boolean.FALSE;
        }
        if (arg.indexOf(46) != -1) {
            try {
                return Float.valueOf(arg);
            }
            catch (NumberFormatException numberFormatException) {
                return arg;
            }
        }
        try {
            return Integer.valueOf(arg);
        }
        catch (NumberFormatException numberFormatException) {
            return arg;
        }
    }

    public static String unEscapeString(String str) throws CoreException {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '\'') {
                if (i == str.length() - 1 || str.charAt(i + 1) != '\'') {
                    throw new CoreException((IStatus)new ExpressionStatus(302, Messages.format(ExpressionMessages.Expression_string_not_correctly_escaped, str)));
                }
                result.append('\'');
                ++i;
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }
}

