/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.InetAddressSet;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InetAccessHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(InetAccessHandler.class);
    private final IncludeExcludeSet<String, InetAddress> _addrs = new IncludeExcludeSet(InetAddressSet.class);
    private final IncludeExclude<String> _names = new IncludeExclude();

    public void clear() {
        this._addrs.clear();
        this._names.clear();
    }

    public void include(String pattern) {
        this._addrs.include((Object)pattern);
    }

    public void include(String ... patterns) {
        this._addrs.include((Object[])patterns);
    }

    public void exclude(String pattern) {
        this._addrs.exclude((Object)pattern);
    }

    public void exclude(String ... patterns) {
        this._addrs.exclude((Object[])patterns);
    }

    public void includeConnector(String name) {
        this._names.include((Object)name);
    }

    public void excludeConnector(String name) {
        this._names.exclude((Object)name);
    }

    public void includeConnectors(String ... names) {
        this._names.include((Object[])names);
    }

    public void excludeConnectors(String ... names) {
        this._names.exclude((Object[])names);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        InetSocketAddress address;
        EndPoint endp;
        HttpChannel channel = baseRequest.getHttpChannel();
        if (channel != null && (endp = channel.getEndPoint()) != null && (address = endp.getRemoteAddress()) != null && !this.isAllowed(address.getAddress(), baseRequest, request)) {
            response.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle(target, baseRequest, request, response);
    }

    protected boolean isAllowed(InetAddress addr, Request baseRequest, HttpServletRequest request) {
        String name = baseRequest.getHttpChannel().getConnector().getName();
        if (LOG.isDebugEnabled()) {
            Boolean allowedByName = this._names.isIncludedAndNotExcluded((Object)name);
            Boolean allowedByAddr = this._addrs.isIncludedAndNotExcluded((Object)addr);
            LOG.debug("{} allowedByName={} allowedByAddr={} for {}/{}", new Object[]{this, allowedByName, allowedByAddr, addr, request});
        }
        return this._names.test((Object)name) && this._addrs.test((Object)addr);
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("included", (Collection)this._addrs.getIncluded()), new DumpableCollection("excluded", (Collection)this._addrs.getExcluded()), new DumpableCollection("includedConnector", (Collection)this._names.getIncluded()), new DumpableCollection("excludedConnector", (Collection)this._names.getExcluded())});
    }
}

