/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.DelegatingValueProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public class AnonymousBeanValueProperty<S, T>
extends DelegatingValueProperty<S, T> {
    private final String propertyName;
    private Map<Class<S>, IValueProperty<S, T>> delegates;

    public AnonymousBeanValueProperty(String propertyName, Class<T> valueType) {
        super(valueType);
        this.propertyName = propertyName;
        this.delegates = new HashMap<Class<S>, IValueProperty<S, T>>();
    }

    protected IValueProperty<S, T> doGetDelegate(S source) {
        return this.getClassDelegate(source.getClass());
    }

    private IValueProperty<S, T> getClassDelegate(Class<S> beanClass) {
        IBeanValueProperty delegate;
        if (this.delegates.containsKey(beanClass)) {
            return this.delegates.get(beanClass);
        }
        try {
            delegate = BeanProperties.value(beanClass, this.propertyName, (Class)this.getValueType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public <M extends S> IObservableValue<T> observeDetail(IObservableValue<M> master) {
        Object valueType = this.getValueType();
        if (valueType == null) {
            valueType = this.inferValueType(master.getValueType());
        }
        return MasterDetailObservables.detailValue(master, (IObservableFactory)this.valueFactory(master.getRealm()), (Object)valueType);
    }

    private Object inferValueType(Object masterObservableValueType) {
        if (masterObservableValueType instanceof Class) {
            IValueProperty<S, T> classDelegate = this.getClassDelegate((Class)masterObservableValueType);
            return classDelegate != null ? classDelegate.getValueType() : null;
        }
        return null;
    }

    public String toString() {
        String s = "?." + this.propertyName;
        Class valueType = (Class)this.getValueType();
        if (valueType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(valueType) + ">";
        }
        return s;
    }
}

