/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner;

import java.util.ArrayList;
import org.eclipse.jdt.internal.junit.runner.IClassifiesThrowables;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.IStopListener;
import org.eclipse.jdt.internal.junit.runner.ITestReference;

public class TestExecution {
    private boolean fShouldStop = false;
    private IListensToTestExecutions fExecutionListener;
    private IClassifiesThrowables fClassifier;
    private ArrayList<IStopListener> fStopListeners = new ArrayList();

    public TestExecution(IListensToTestExecutions listener, IClassifiesThrowables classifier) {
        this.fClassifier = classifier;
        this.fExecutionListener = listener;
    }

    public void run(ITestReference[] suites) {
        int i = 0;
        while (i < suites.length) {
            if (this.fShouldStop) {
                return;
            }
            suites[i].run(this);
            ++i;
        }
    }

    public boolean shouldStop() {
        return this.fShouldStop;
    }

    public void stop() {
        this.fShouldStop = true;
        for (IStopListener listener : this.fStopListeners) {
            listener.stop();
        }
    }

    public IListensToTestExecutions getListener() {
        return this.fExecutionListener;
    }

    public IClassifiesThrowables getClassifier() {
        return this.fClassifier;
    }

    public void addStopListener(IStopListener listener) {
        this.fStopListeners.add(listener);
    }
}

