/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.URIConverter;

class URIMappingRegistryReader
extends RegistryReader {
    static final String TAG_MAPPING = "mapping";
    static final String ATT_SOURCE = "source";
    static final String ATT_TARGET = "target";
    protected Map<URI, IConfigurationElement> map = new HashMap<URI, IConfigurationElement>();

    public URIMappingRegistryReader() {
        super(RegistryFactory.getRegistry(), EcorePlugin.INSTANCE.getSymbolicName(), "uri_mapping");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_MAPPING)) {
            String sourceURIValue = element.getAttribute(ATT_SOURCE);
            if (sourceURIValue == null) {
                this.logMissingAttribute(element, ATT_SOURCE);
            } else {
                String targetURIValue = element.getAttribute(ATT_TARGET);
                if (targetURIValue == null) {
                    this.logMissingAttribute(element, ATT_TARGET);
                } else {
                    if (add) {
                        URI sourceURI = URI.createURI((String)sourceURIValue);
                        URI targetURI = URI.createURI((String)targetURIValue);
                        if (targetURI.isRelative() && targetURI.hasRelativePath()) {
                            targetURI = targetURI.resolve(URI.createPlatformPluginURI((String)(String.valueOf(element.getDeclaringExtension().getContributor().getName()) + "/"), (boolean)true));
                        }
                        URIConverter.URI_MAP.put(sourceURI, targetURI);
                        IConfigurationElement previous = this.map.put(sourceURI, element);
                        if (previous != null) {
                            EcorePlugin.INSTANCE.log("Both '" + previous.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a URI mapping for '" + sourceURI + "'");
                        }
                        return true;
                    }
                    URI sourceURI = URI.createURI((String)sourceURIValue);
                    URIConverter.URI_MAP.remove(sourceURI);
                    this.map.remove(sourceURI);
                    return true;
                }
            }
        }
        return false;
    }
}

