/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.impl.helper.ComponentServiceObjectsHelper;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.EdgeInfo;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;

public class ComponentContextImpl<S>
implements ScrComponentContext {
    private final SingleComponentManager<S> m_componentManager;
    private final EdgeInfo[] edgeInfos;
    private final ComponentInstance<S> m_componentInstance = new ComponentInstanceImpl(this);
    private final Bundle m_usingBundle;
    private volatile ServiceRegistration<S> m_serviceRegistration;
    private volatile S m_implementationObject;
    private volatile boolean m_implementationAccessible;
    private final CountDownLatch accessibleLatch = new CountDownLatch(1);
    private final ComponentServiceObjectsHelper serviceObjectsHelper;
    private Map<String, Map<RefPair<?, ?>, Object>> boundValues;

    public ComponentContextImpl(SingleComponentManager<S> componentManager, Bundle usingBundle, ServiceRegistration<S> serviceRegistration) {
        this.m_componentManager = componentManager;
        this.m_usingBundle = usingBundle;
        this.m_serviceRegistration = serviceRegistration;
        this.edgeInfos = new EdgeInfo[componentManager.getComponentMetadata().getDependencies().size()];
        for (int i = 0; i < this.edgeInfos.length; ++i) {
            this.edgeInfos[i] = new EdgeInfo();
        }
        this.serviceObjectsHelper = new ComponentServiceObjectsHelper(usingBundle.getBundleContext());
    }

    public void unsetServiceRegistration() {
        this.m_serviceRegistration = null;
    }

    public void cleanup() {
        this.serviceObjectsHelper.cleanup();
    }

    @Override
    public ComponentServiceObjectsHelper getComponentServiceObjectsHelper() {
        return this.serviceObjectsHelper;
    }

    public void setImplementationObject(S implementationObject) {
        this.m_implementationObject = implementationObject;
    }

    public void setImplementationAccessible(boolean implementationAccessible) {
        this.m_implementationAccessible = implementationAccessible;
        if (implementationAccessible) {
            this.accessibleLatch.countDown();
        }
    }

    EdgeInfo getEdgeInfo(DependencyManager<S, ?> dm) {
        int index = dm.getIndex();
        return this.edgeInfos[index];
    }

    ServiceRegistration<S> getServiceRegistration() {
        return this.m_serviceRegistration;
    }

    protected SingleComponentManager<S> getComponentManager() {
        return this.m_componentManager;
    }

    @Override
    public ComponentMetadata getComponentMetadata() {
        return this.m_componentManager.getComponentMetadata();
    }

    public final Dictionary<String, Object> getProperties() {
        return new ReadOnlyDictionary(this.m_componentManager.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object locateService(String name) {
        this.m_componentManager.obtainActivationReadLock();
        try {
            DependencyManager dm = this.m_componentManager.getDependencyManager(name);
            Object var3_3 = dm != null ? dm.getService(this) : null;
            return var3_3;
        }
        finally {
            this.m_componentManager.releaseActivationReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object locateService(String name, ServiceReference ref) {
        this.m_componentManager.obtainActivationReadLock();
        try {
            DependencyManager dm = this.m_componentManager.getDependencyManager(name);
            Object var4_4 = dm != null ? dm.getService(this, ref) : null;
            return var4_4;
        }
        finally {
            this.m_componentManager.releaseActivationReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] locateServices(String name) {
        this.m_componentManager.obtainActivationReadLock();
        try {
            DependencyManager dm = this.m_componentManager.getDependencyManager(name);
            Object[] objectArray = dm != null ? dm.getServices(this) : null;
            return objectArray;
        }
        finally {
            this.m_componentManager.releaseActivationReadLock();
        }
    }

    public BundleContext getBundleContext() {
        return this.m_componentManager.getBundleContext();
    }

    public Bundle getUsingBundle() {
        return this.m_usingBundle;
    }

    @Override
    public ComponentLogger getLogger() {
        return this.m_componentManager.getLogger();
    }

    public ComponentInstance<S> getComponentInstance() {
        return this.m_componentInstance;
    }

    public void enableComponent(String name) {
        this.m_componentManager.getActivator().enableComponent(name);
    }

    public void disableComponent(String name) {
        this.m_componentManager.getActivator().disableComponent(name);
    }

    public ServiceReference<S> getServiceReference() {
        return this.m_serviceRegistration == null ? null : this.m_serviceRegistration.getReference();
    }

    @Override
    public void setServiceProperties(Dictionary<String, ?> properties) {
        this.getComponentManager().setServiceProperties(properties);
    }

    S getImplementationObject(boolean requireAccessible) {
        if (!requireAccessible || this.m_implementationAccessible) {
            return this.m_implementationObject;
        }
        try {
            if (this.accessibleLatch.await(this.m_componentManager.getLockTimeout(), TimeUnit.MILLISECONDS) && this.m_implementationAccessible) {
                return this.m_implementationObject;
            }
        }
        catch (InterruptedException e) {
            try {
                if (this.accessibleLatch.await(this.m_componentManager.getLockTimeout(), TimeUnit.MILLISECONDS) && this.m_implementationAccessible) {
                    return this.m_implementationObject;
                }
            }
            catch (InterruptedException e1) {
                this.m_componentManager.getLogger().log(InternalLogger.Level.INFO, "Interrupted twice waiting for implementation object to become accessible", e1);
            }
            Thread.currentThread().interrupt();
            return null;
        }
        return null;
    }

    @Override
    public synchronized Map<RefPair<?, ?>, Object> getBoundValues(String key) {
        Map<RefPair<?, ?>, Object> map;
        if (this.boundValues == null) {
            this.boundValues = new HashMap();
        }
        if ((map = this.boundValues.get(key)) == null) {
            map = this.createNewFieldHandlerMap();
            this.boundValues.put(key, map);
        }
        return map;
    }

    private Map<RefPair<?, ?>, Object> createNewFieldHandlerMap() {
        return new TreeMap(new Comparator<RefPair<?, ?>>(){

            @Override
            public int compare(RefPair<?, ?> o1, RefPair<?, ?> o2) {
                return o1.getRef().compareTo(o2.getRef());
            }
        });
    }

    private static class ComponentInstanceImpl<S>
    implements ComponentInstance<S> {
        private final ComponentContextImpl<S> m_componentContext;

        private ComponentInstanceImpl(ComponentContextImpl<S> m_componentContext) {
            this.m_componentContext = m_componentContext;
        }

        public S getInstance() {
            return this.m_componentContext.getImplementationObject(true);
        }

        public void dispose() {
            this.m_componentContext.getComponentManager().dispose();
        }
    }
}

