/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.internal.widgets.LayoutUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressCollector
extends Composite {
    private ProgressBar progressBar;
    private final List<String> completedFiles;
    private final List<Exception> uploadExceptions;

    public ProgressCollector(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)LayoutUtil.createGridLayout(2, 0, 5));
        this.createChildren();
        this.completedFiles = new ArrayList<String>();
        this.uploadExceptions = new ArrayList<Exception>();
    }

    public String[] getCompletedFileNames() {
        return this.completedFiles.toArray(new String[0]);
    }

    public List<Exception> getUploadExceptions() {
        return new ArrayList<Exception>(this.uploadExceptions);
    }

    private void createChildren() {
        this.progressBar = new ProgressBar((Composite)this, 256);
        this.progressBar.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
    }

    void updateProgress(int percent) {
        if (!this.isDisposed()) {
            this.progressBar.setSelection(percent);
            this.progressBar.setToolTipText(String.valueOf(percent) + "%");
        }
    }

    void updateCompletedFiles(List<String> fileNames) {
        if (!this.isDisposed()) {
            this.completedFiles.addAll(fileNames);
        }
    }

    void addException(Exception exception) {
        if (!this.isDisposed()) {
            this.uploadExceptions.add(exception);
        }
    }

    void resetToolTip() {
        if (!this.isDisposed()) {
            this.progressBar.setToolTipText(null);
        }
    }
}

