/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class FormImages {
    private static FormImages instance;
    private HashMap descriptors;

    public static FormImages getInstance() {
        if (instance == null) {
            instance = new FormImages();
        }
        return instance;
    }

    private FormImages() {
    }

    public synchronized boolean markFinished(Image image) {
        this.checkHashMaps();
        AbstractImageDescriptor desc = (AbstractImageDescriptor)((Object)this.descriptors.get(image));
        if (desc != null) {
            this.descriptors.remove(image);
            this.validateHashMaps();
            return true;
        }
        return false;
    }

    private void checkHashMaps() {
        if (this.descriptors == null) {
            this.descriptors = new HashMap();
        }
    }

    private void validateHashMaps() {
        if (this.descriptors.size() == 0) {
            this.descriptors = null;
        }
    }

    private abstract class AbstractImageDescriptor
    extends ImageDescriptor {
        RGB[] fRGBs;
        int fLength;

        AbstractImageDescriptor(Color[] colors, int length) {
            this.fRGBs = new RGB[colors.length];
            int i = 0;
            while (i < colors.length) {
                Color color = colors[i];
                this.fRGBs[i] = color == null ? null : color.getRGB();
                ++i;
            }
            this.fLength = length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AbstractImageDescriptor) {
                AbstractImageDescriptor id = (AbstractImageDescriptor)((Object)obj);
                if (id.fRGBs.length == this.fRGBs.length) {
                    boolean result = id.fLength == this.fLength;
                    int i = 0;
                    while (i < this.fRGBs.length && result) {
                        result = result && id.fRGBs[i].equals((Object)this.fRGBs[i]);
                        ++i;
                    }
                    return result;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.fRGBs.length) {
                hash = hash * 7 + this.fRGBs[i].hashCode();
                ++i;
            }
            hash = hash * 7 + this.fLength;
            return hash;
        }
    }
}

