/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.container;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleWire;

public class NamespaceList<E> {
    public static final Function<ModuleWire, String> WIRE = wire -> wire.getCapability().getNamespace();
    public static final Function<ModuleCapability, String> CAPABILITY = ModuleCapability::getNamespace;
    public static final Function<ModuleRequirement, String> REQUIREMENT = ModuleRequirement::getNamespace;
    private final List<E> elements;
    private final Map<String, List<E>> namespaces;
    private final Function<E, String> getNamespace;

    public static <E> NamespaceList<E> empty(Function<E, String> getNamespace) {
        return new NamespaceList<E>(getNamespace, Collections.emptyMap(), Collections.emptyList());
    }

    NamespaceList(Function<E, String> getNamespace, Map<String, List<E>> namespaces, List<E> fullList) {
        this.getNamespace = getNamespace;
        this.namespaces = namespaces;
        this.elements = fullList;
    }

    Map<String, List<E>> namespaces() {
        return this.namespaces;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public List<E> getList(String namespace) {
        if (namespace == null) {
            return this.elements;
        }
        return this.namespaces.getOrDefault(namespace, Collections.emptyList());
    }

    public Builder<E> createBuilder() {
        Builder<E> builder = Builder.create(this.getNamespace);
        builder.addAll(this);
        return builder;
    }

    public static class Builder<E>
    extends AbstractCollection<E> {
        private final Function<E, String> getNamespace;
        private LinkedHashMap<String, List<E>> namespaceElements;
        private int size = 0;
        private List<E> lastBuildElements;

        public static <E> Builder<E> create(Function<E, String> getNamespace) {
            return new Builder<E>(getNamespace, 3);
        }

        private Builder(Function<E, String> getNamespace, int expectedNamespaces) {
            this.getNamespace = getNamespace;
            this.namespaceElements = new LinkedHashMap(expectedNamespaces * 4 / 3 + 1);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<E> iterator() {
            this.prepareModification();
            final Iterator<List<E>> outer = this.namespaceElements.values().iterator();
            return new Iterator<E>(){
                Iterator<E> inner = Collections.emptyIterator();
                List<E> lastInnerList = null;

                @Override
                public boolean hasNext() {
                    while (!this.inner.hasNext() && outer.hasNext()) {
                        this.lastInnerList = (List)outer.next();
                        this.inner = this.lastInnerList.iterator();
                    }
                    return this.inner.hasNext();
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.inner.next();
                }

                @Override
                public void remove() {
                    this.inner.remove();
                    Builder builder = this;
                    builder.size = builder.size - 1;
                    if (this.lastInnerList.isEmpty()) {
                        outer.remove();
                    }
                }
            };
        }

        @Override
        public void clear() {
            this.namespaceElements = new LinkedHashMap();
            this.lastBuildElements = null;
            this.size = 0;
        }

        @Override
        public boolean add(E e) {
            this.prepareModification();
            String namespace = this.getNamespace.apply(e);
            this.getNamespaceList(namespace).add(e);
            ++this.size;
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (c.isEmpty()) {
                return false;
            }
            this.prepareModification();
            String currentNamespace = null;
            List<E> currentNamespaceList = null;
            for (E e : c) {
                String namespace = this.getNamespace.apply(e);
                if (currentNamespace == null || !currentNamespace.equals(namespace)) {
                    currentNamespace = namespace;
                    currentNamespaceList = this.getNamespaceList(namespace);
                }
                currentNamespaceList.add(e);
            }
            this.size += c.size();
            return true;
        }

        @Override
        public boolean addAll(NamespaceList<E> list) {
            if (list.isEmpty()) {
                return false;
            }
            this.prepareModification();
            list.namespaces().forEach((? super K n, ? super V es) -> {
                this.getNamespaceList((String)n).addAll((Collection<E>)es);
                this.size += es.size();
            });
            return true;
        }

        private List<E> getNamespaceList(String namespace) {
            return this.namespaceElements.computeIfAbsent(namespace, n -> new ArrayList());
        }

        public void addAfterLastMatch(E toAdd, Predicate<E> matcher) {
            this.prepareModification();
            String namespace = this.getNamespace.apply(toAdd);
            List<E> namespaceList = this.getNamespaceList(namespace);
            this.addAfterLastMatch(toAdd, namespaceList, matcher);
            ++this.size;
        }

        private void addAfterLastMatch(E e, List<E> list, Predicate<E> matcher) {
            int i = list.size() - 1;
            while (i >= 0) {
                if (matcher.test(list.get(i))) {
                    list.add(i + 1, e);
                    return;
                }
                --i;
            }
            list.add(0, e);
        }

        @Override
        public boolean remove(Object o) {
            String namespace;
            Object e = o;
            try {
                namespace = this.getNamespace.apply(e);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            this.prepareModification();
            int sizeBefore = this.size;
            this.removeNamespaceElement(namespace, e);
            return this.size < sizeBefore;
        }

        private void removeNamespaceElement(String namespace, E element) {
            this.namespaceElements.computeIfPresent(namespace, (n, es) -> {
                if (es.remove(element)) {
                    --this.size;
                }
                return es.isEmpty() ? null : es;
            });
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c.isEmpty()) {
                return false;
            }
            this.prepareModification();
            boolean removed = false;
            for (Object e : c) {
                removed |= this.remove(e);
            }
            return removed;
        }

        public void removeNamespaceIf(Predicate<String> filter) {
            this.prepareModification();
            this.namespaceElements.entrySet().removeIf(e -> {
                if (filter.test((String)e.getKey())) {
                    this.size -= ((List)e.getValue()).size();
                    return true;
                }
                return false;
            });
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            this.prepareModification();
            int s = this.size;
            this.namespaceElements.values().removeIf(es -> this.removeElementsIf((List<E>)es, filter) == null);
            return this.size < s;
        }

        public void removeElementsOfNamespaceIf(String namespace, Predicate<? super E> filter) {
            this.prepareModification();
            this.namespaceElements.computeIfPresent(namespace, (n, es) -> this.removeElementsIf((List<E>)es, filter));
        }

        private List<E> removeElementsIf(List<E> list, Predicate<? super E> filter) {
            int sizeBefore = list.size();
            list.removeIf(filter);
            this.size -= sizeBefore - list.size();
            return list.isEmpty() ? null : list;
        }

        public NamespaceList<E> build() {
            if (this.size == 0) {
                return NamespaceList.empty(this.getNamespace);
            }
            if (this.lastBuildElements == null) {
                this.lastBuildElements = new ArrayList(this.size);
                this.namespaceElements.values().forEach(this.lastBuildElements::addAll);
                this.lastBuildElements = Collections.unmodifiableList(this.lastBuildElements);
                int[] start = new int[1];
                this.namespaceElements.replaceAll((n, es) -> {
                    int from = start[0];
                    int to = nArray[0] = start[0] + es.size();
                    return this.lastBuildElements.subList(from, to);
                });
            }
            return new NamespaceList<E>(this.getNamespace, this.namespaceElements, this.lastBuildElements);
        }

        private void prepareModification() {
            if (this.lastBuildElements != null) {
                this.namespaceElements = new LinkedHashMap<String, List<E>>(this.namespaceElements);
                this.namespaceElements.replaceAll((n, es) -> new ArrayList(es));
                this.lastBuildElements = null;
            }
        }
    }
}

