/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class AuthorizationHandler {
    static final String F_KEYRING = ".keyring";
    private static long keyringTimeStamp;
    private static String password;
    private static String keyringFile;
    private static Object keyring;
    private static Class<?> authClass;
    private static boolean authNotAvailableLogged;

    static {
        password = "";
        keyringFile = null;
        keyring = null;
        authNotAvailableLogged = false;
    }

    private static Class<?> getAuthClass() {
        if (authClass == null) {
            try {
                authClass = Class.forName("org.eclipse.core.internal.runtime.auth.AuthorizationDatabase");
            }
            catch (ClassNotFoundException e) {
                AuthorizationHandler.logAuthNotAvailable(e);
            }
        }
        return authClass;
    }

    private static void logAuthNotAvailable(Throwable e) {
        if (authNotAvailableLogged) {
            return;
        }
        authNotAvailableLogged = true;
        RuntimeLog.log((IStatus)new Status(2, "org.eclipse.core.runtime", 0, Messages.auth_notAvailable, e));
    }

    private static boolean loadKeyring() throws CoreException {
        Constructor<?> constructor;
        boolean found;
        if (AuthorizationHandler.getAuthClass() == null) {
            return false;
        }
        if (keyring != null && new File(keyringFile).lastModified() == keyringTimeStamp) {
            return true;
        }
        if (keyringFile == null && !(found = ServiceCaller.callOnce(AuthorizationHandler.class, Location.class, (String)Location.CONFIGURATION_FILTER, configurationLocation -> {
            File file = new File(String.valueOf(configurationLocation.getURL().getPath()) + "/org.eclipse.core.runtime");
            file = new File(file, F_KEYRING);
            keyringFile = file.getAbsolutePath();
        }))) {
            return true;
        }
        try {
            constructor = authClass.getConstructor(String.class, String.class);
            keyring = constructor.newInstance(keyringFile, password);
        }
        catch (Exception e) {
            AuthorizationHandler.log(e);
        }
        if (keyring == null) {
            new File(keyringFile).delete();
            try {
                constructor = authClass.getConstructor(String.class, String.class);
                keyring = constructor.newInstance(keyringFile, password);
            }
            catch (Exception exception) {}
        }
        keyringTimeStamp = new File(keyringFile).lastModified();
        return true;
    }

    private static void log(Exception e) throws CoreException {
        Throwable cause;
        if (e instanceof InvocationTargetException && (cause = ((InvocationTargetException)e).getTargetException()) instanceof CoreException) {
            throw (CoreException)cause;
        }
        AuthorizationHandler.logAuthNotAvailable(e);
    }

    private static void saveKeyring() throws CoreException {
        try {
            Method method = authClass.getMethod("save", new Class[0]);
            method.invoke(keyring, new Object[0]);
        }
        catch (Exception e) {
            AuthorizationHandler.log(e);
        }
        keyringTimeStamp = new File(keyringFile).lastModified();
    }

    public static synchronized void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map<String, String> info) throws CoreException {
        if (!AuthorizationHandler.loadKeyring()) {
            return;
        }
        try {
            Method method = authClass.getMethod("addAuthorizationInfo", URL.class, String.class, String.class, Map.class);
            method.invoke(keyring, serverUrl, realm, authScheme, new HashMap<String, String>(info));
        }
        catch (Exception e) {
            AuthorizationHandler.log(e);
        }
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        if (!AuthorizationHandler.loadKeyring()) {
            return;
        }
        try {
            Method method = authClass.getMethod("addProtectionSpace", URL.class, String.class);
            method.invoke(keyring, resourceUrl, realm);
        }
        catch (Exception e) {
            AuthorizationHandler.log(e);
        }
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        if (!AuthorizationHandler.loadKeyring()) {
            return;
        }
        try {
            Method method = authClass.getMethod("flushAuthorizationInfo", URL.class, String.class, String.class);
            method.invoke(keyring, serverUrl, realm, authScheme);
        }
        catch (Exception e) {
            AuthorizationHandler.log(e);
        }
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized Map<String, String> getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        block5: {
            try {
                if (AuthorizationHandler.loadKeyring()) break block5;
                return null;
            }
            catch (CoreException coreException) {}
        }
        try {
            Method method = authClass.getMethod("getAuthorizationInfo", URL.class, String.class, String.class);
            Map info = (Map)method.invoke(keyring, serverUrl, realm, authScheme);
            return info == null ? null : new HashMap(info);
        }
        catch (Exception e) {
            AuthorizationHandler.log(e);
        }
        return null;
    }

    public static synchronized String getProtectionSpace(URL resourceUrl) {
        block5: {
            try {
                if (AuthorizationHandler.loadKeyring()) break block5;
                return null;
            }
            catch (CoreException coreException) {}
        }
        try {
            Method method = authClass.getMethod("getProtectionSpace", URL.class);
            return (String)method.invoke(keyring, resourceUrl);
        }
        catch (Exception e) {
            AuthorizationHandler.log(e);
        }
        return null;
    }

    public static void setKeyringFile(String file) {
        if (keyringFile != null) {
            throw new IllegalStateException(NLS.bind((String)Messages.auth_alreadySpecified, (Object)keyringFile));
        }
        keyringFile = file;
    }

    public static void setPassword(String keyringPassword) {
        password = keyringPassword;
    }
}

